/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.multipleLivesPlugin.commands;

import de.scholle.multipleLivesPlugin.MultipleLivesPlugin;
import de.scholle.multipleLivesPlugin.storage.LivesStore;
import de.scholle.multipleLivesPlugin.utils.Msg;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LivesCommand
implements CommandExecutor {
    private final MultipleLivesPlugin plugin;
    private final LivesStore livesStore;

    public LivesCommand(MultipleLivesPlugin plugin) {
        this.plugin = plugin;
        this.livesStore = plugin.lives();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Msg.comp("&cUsage: /lives <check|view|add|remove|set> [player] [amount]"));
                return true;
            }
            Player p = (Player)sender;
            int lives = this.livesStore.getLives(((Player)sender).getUniqueId());
            sender.sendMessage(Msg.comp("&aYou have &f" + lives + " &alives."));
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "view": {
                if (args.length == 1 && sender instanceof Player) {
                    Player p = (Player)sender;
                    int lives = this.livesStore.getLives(p.getUniqueId());
                    sender.sendMessage(Msg.comp("&aYou have &f" + lives + " &alives."));
                    return true;
                }
                if (args.length < 2) break;
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(Msg.comp("&cPlayer not found."));
                    return true;
                }
                int lives = this.livesStore.getLives(target.getUniqueId());
                sender.sendMessage(Msg.comp("&a" + target.getName() + " has &f" + lives + " &alives."));
                return true;
            }
            case "check": {
                if (args.length < 2) {
                    sender.sendMessage(Msg.comp("&cUsage: /lives check <player>"));
                    return true;
                }
                Player targetCheck = Bukkit.getPlayer((String)args[1]);
                if (targetCheck == null) {
                    sender.sendMessage(Msg.comp("&cPlayer not found."));
                    return true;
                }
                int livesCheck = this.livesStore.getLives(targetCheck.getUniqueId());
                sender.sendMessage(Msg.comp("&a" + targetCheck.getName() + " has &f" + livesCheck + " &alives."));
                return true;
            }
            case "add": 
            case "remove": 
            case "set": {
                int amount;
                if (args.length < 3) {
                    sender.sendMessage(Msg.comp("&cUsage: /lives " + sub + " <player> <amount>"));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(Msg.comp("&cPlayer not found."));
                    return true;
                }
                try {
                    amount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(Msg.comp("&cAmount must be a number."));
                    return true;
                }
                UUID targetId = target.getUniqueId();
                switch (sub) {
                    case "add": {
                        this.livesStore.addLives(targetId, amount);
                        sender.sendMessage(Msg.comp("&aAdded &f" + amount + " &alives to &f" + target.getName()));
                        break;
                    }
                    case "remove": {
                        this.livesStore.removeLives(targetId, amount);
                        sender.sendMessage(Msg.comp("&aRemoved &f" + amount + " &alives from &f" + target.getName()));
                        break;
                    }
                    case "set": {
                        this.livesStore.setLives(targetId, amount);
                        sender.sendMessage(Msg.comp("&aSet &f" + target.getName() + "'s &alives to &f" + amount));
                    }
                }
                break;
            }
            default: {
                sender.sendMessage(Msg.comp("&cUnknown subcommand. Use check|view|add|remove|set"));
            }
        }
        return true;
    }
}

