/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.multipleLivesPlugin.listeners;

import de.scholle.multipleLivesPlugin.MultipleLivesPlugin;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.projectiles.ProjectileSource;

public class CombatListener
implements Listener {
    private final MultipleLivesPlugin plugin;

    public CombatListener(MultipleLivesPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        Projectile proj;
        ProjectileSource shooter;
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Player attacker = null;
        Entity damager = e.getDamager();
        if (damager instanceof Player) {
            Player player;
            attacker = player = (Player)damager;
        } else if (damager instanceof Projectile && (shooter = (proj = (Projectile)damager).getShooter()) instanceof Player) {
            Player player;
            attacker = player = (Player)shooter;
        }
        if (attacker == null) {
            return;
        }
        if (!this.plugin.combat().isPvPEnabled()) {
            e.setCancelled(true);
            return;
        }
        this.plugin.combat().startOrRefreshCombat(attacker, victim);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player victim = e.getEntity();
        Player killer = victim.getKiller();
        this.plugin.combat().clearCombat(victim.getUniqueId(), false);
        if (killer != null) {
            this.plugin.combat().clearCombat(killer.getUniqueId(), false);
        }
    }
}

