/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.multipleLivesPlugin.manager;

import de.scholle.multipleLivesPlugin.MultipleLivesPlugin;
import de.scholle.multipleLivesPlugin.utils.Msg;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CombatManager {
    private final MultipleLivesPlugin plugin;
    private final Map<UUID, Long> combatUntil;
    private final Map<UUID, UUID> lastAttacker;
    private final Map<UUID, Long> lastAttackMsg;
    private final Set<UUID> wasInCombat;
    private boolean pvpEnabled;
    private BukkitTask barTask;
    private long combatDurationMs;

    public CombatManager(MultipleLivesPlugin plugin) {
        this.plugin = plugin;
        this.combatUntil = new HashMap<UUID, Long>();
        this.lastAttacker = new HashMap<UUID, UUID>();
        this.lastAttackMsg = new HashMap<UUID, Long>();
        this.wasInCombat = new HashSet<UUID>();
        this.pvpEnabled = true;
        int durationSeconds = plugin.getConfig().getInt("combatduration", 30);
        this.combatDurationMs = (long)durationSeconds * 1000L;
    }

    public void start() {
        this.stop();
        this.barTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            for (Player p : Bukkit.getOnlinePlayers()) {
                UUID id = p.getUniqueId();
                Long until = this.combatUntil.get(id);
                if (until != null && until > now) {
                    this.wasInCombat.add(id);
                    long secs = (until - now) / 1000L;
                    p.sendActionBar(Msg.comp("&cIn combat! &7(" + secs + " s left)"));
                    continue;
                }
                if (!this.wasInCombat.remove(id)) continue;
                this.clearCombat(id, true);
            }
        }, 20L, 20L);
    }

    public void stop() {
        if (this.barTask != null) {
            this.barTask.cancel();
            this.barTask = null;
        }
    }

    public void shutdown() {
        this.stop();
        this.combatUntil.clear();
        this.lastAttacker.clear();
        this.lastAttackMsg.clear();
        this.wasInCombat.clear();
    }

    public void startOrRefreshCombat(Player attacker, Player victim) {
        long now = System.currentTimeMillis();
        long until = now + this.combatDurationMs;
        this.combatUntil.put(attacker.getUniqueId(), until);
        this.combatUntil.put(victim.getUniqueId(), until);
        this.lastAttacker.put(victim.getUniqueId(), attacker.getUniqueId());
        this.wasInCombat.add(attacker.getUniqueId());
        this.wasInCombat.add(victim.getUniqueId());
    }

    public boolean isInCombat(UUID id) {
        Long until = this.combatUntil.get(id);
        return until != null && until > System.currentTimeMillis();
    }

    public void clearCombat(UUID id, boolean notify) {
        Player p;
        this.combatUntil.remove(id);
        this.wasInCombat.remove(id);
        this.lastAttacker.remove(id);
        this.lastAttackMsg.remove(id);
        if (notify && (p = Bukkit.getPlayer((UUID)id)) != null) {
            p.sendMessage(Msg.comp("&aYou are safe. Combat ended."));
        }
    }

    public void setPvPEnabled(boolean enabled, CommandSender actor) {
        this.pvpEnabled = enabled;
        String actorName = actor != null ? actor.getName() : "Console";
        String msg = enabled ? "&ePvP enabled by &a" + actorName : "&ePvP disabled by &c" + actorName;
        Bukkit.getServer().broadcast(Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] " + msg));
    }

    public boolean isPvPEnabled() {
        return this.pvpEnabled;
    }
}

