/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.multipleLivesPlugin.storage;

import de.scholle.multipleLivesPlugin.MultipleLivesPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LivesStore {
    private final MultipleLivesPlugin plugin;
    private final File file;
    private final FileConfiguration cfg;

    public LivesStore(MultipleLivesPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "lives.yml");
        this.cfg = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public int getLives(UUID id) {
        int def = this.plugin.getConfig().getInt("startingLives", 3);
        return this.cfg.getInt("players." + String.valueOf(id) + ".lives", def);
    }

    public void setLives(UUID id, int lives) {
        int max = this.plugin.getConfig().getInt("maxLives", 3);
        int clamped = Math.max(0, Math.min(max, lives));
        this.cfg.set("players." + String.valueOf(id) + ".lives", (Object)clamped);
        this.saveNow();
    }

    public void addLives(UUID id, int amount) {
        if (amount <= 0) {
            return;
        }
        this.setLives(id, this.getLives(id) + amount);
    }

    public void removeLives(UUID id, int amount) {
        if (amount <= 0) {
            return;
        }
        this.setLives(id, this.getLives(id) - amount);
    }

    public void ensureDefault(UUID id) {
        String path = "players." + String.valueOf(id) + ".lives";
        if (!this.cfg.isSet(path)) {
            this.cfg.set(path, (Object)this.plugin.getConfig().getInt("startingLives", 3));
            this.saveNow();
        }
    }

    public void saveNow() {
        try {
            this.cfg.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save lives.yml: " + e.getMessage());
        }
    }

    public Map<UUID, String> getEliminatedNames() {
        HashMap<UUID, String> out = new HashMap<UUID, String>();
        ConfigurationSection sec = this.cfg.getConfigurationSection("players");
        if (sec == null) {
            return out;
        }
        for (String key : sec.getKeys(false)) {
            try {
                OfflinePlayer off;
                String name;
                UUID id = UUID.fromString(key);
                int lives = sec.getInt(key + ".lives", this.plugin.getConfig().getInt("startingLives", 3));
                if (lives > 0 || (name = (off = Bukkit.getOfflinePlayer((UUID)id)).getName()) == null) continue;
                out.put(id, name);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return out;
    }
}

