/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.recipecreate;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RecipeCreateGUI {
    public static void openMainMenu(Player player) {
        Inventory menu = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Main Menu"));
        ItemStack shapedRecipeButton = RecipeCreateGUI.createGuiItem(Material.CRAFTING_TABLE, String.valueOf(ChatColor.GREEN) + "Create Shaped Recipe", String.valueOf(ChatColor.GRAY) + "Create a recipe with a specific pattern");
        menu.setItem(11, shapedRecipeButton);
        ItemStack shapelessRecipeButton = RecipeCreateGUI.createGuiItem(Material.BREWING_STAND, String.valueOf(ChatColor.GREEN) + "Create Shapeless Recipe", String.valueOf(ChatColor.GRAY) + "Create a recipe with no specific pattern");
        menu.setItem(13, shapelessRecipeButton);
        ItemStack listButton = RecipeCreateGUI.createGuiItem(Material.BOOK, String.valueOf(ChatColor.YELLOW) + "List Recipes", String.valueOf(ChatColor.GRAY) + "View all custom recipes");
        menu.setItem(15, listButton);
        ItemStack helpButton = RecipeCreateGUI.createGuiItem(Material.COMPASS, String.valueOf(ChatColor.AQUA) + "Help", String.valueOf(ChatColor.GRAY) + "Show plugin help");
        menu.setItem(22, helpButton);
        ItemStack exitButton = RecipeCreateGUI.createGuiItem(Material.BARRIER, String.valueOf(ChatColor.RED) + "Exit", String.valueOf(ChatColor.GRAY) + "Close this menu");
        menu.setItem(26, exitButton);
        for (int i = 0; i < 27; ++i) {
            if (menu.getItem(i) != null) continue;
            menu.setItem(i, RecipeCreateGUI.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
        }
        player.openInventory(menu);
    }

    public static void openShapedRecipeMenu(Player player) {
        Inventory menu = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shaped Recipe"));
        ItemStack gridBorder = RecipeCreateGUI.createGuiItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, String.valueOf(ChatColor.BLUE) + "Crafting Grid", String.valueOf(ChatColor.GRAY) + "Place ingredients here");
        menu.setItem(1, gridBorder);
        menu.setItem(2, gridBorder);
        menu.setItem(3, gridBorder);
        menu.setItem(9, gridBorder);
        menu.setItem(18, gridBorder);
        menu.setItem(27, gridBorder);
        menu.setItem(13, gridBorder);
        menu.setItem(22, gridBorder);
        menu.setItem(31, gridBorder);
        menu.setItem(37, gridBorder);
        menu.setItem(38, gridBorder);
        menu.setItem(39, gridBorder);
        ItemStack arrowItem = RecipeCreateGUI.createGuiItem(Material.ARROW, String.valueOf(ChatColor.WHITE) + "\u2192", String.valueOf(ChatColor.GRAY) + "Creates");
        menu.setItem(23, arrowItem);
        ItemStack nameInput = RecipeCreateGUI.createGuiItem(Material.NAME_TAG, String.valueOf(ChatColor.YELLOW) + "Recipe Name", String.valueOf(ChatColor.GRAY) + "Click to set the recipe name");
        menu.setItem(42, nameInput);
        ItemStack maxCraftsInput = RecipeCreateGUI.createGuiItem(Material.HOPPER, String.valueOf(ChatColor.GOLD) + "Max Crafts: Unlimited", String.valueOf(ChatColor.GRAY) + "Click to set usage limit", String.valueOf(ChatColor.GRAY) + "Leave unlimited or set a number", String.valueOf(ChatColor.AQUA) + "Examples:", String.valueOf(ChatColor.WHITE) + "\u2022 1 = Only one person can craft", String.valueOf(ChatColor.WHITE) + "\u2022 5 = Can be crafted 5 times total", String.valueOf(ChatColor.WHITE) + "\u2022 Unlimited = No limit");
        menu.setItem(43, maxCraftsInput);
        ItemStack saveButton = RecipeCreateGUI.createGuiItem(Material.EMERALD_BLOCK, String.valueOf(ChatColor.GREEN) + "Save Recipe", String.valueOf(ChatColor.GRAY) + "Click to save this recipe");
        menu.setItem(51, saveButton);
        ItemStack cancelButton = RecipeCreateGUI.createGuiItem(Material.REDSTONE_BLOCK, String.valueOf(ChatColor.RED) + "Cancel", String.valueOf(ChatColor.GRAY) + "Click to cancel");
        menu.setItem(52, cancelButton);
        ItemStack instructionsButton = RecipeCreateGUI.createGuiItem(Material.PAPER, String.valueOf(ChatColor.AQUA) + "Instructions", String.valueOf(ChatColor.GRAY) + "Click items in your inventory to add", String.valueOf(ChatColor.GRAY) + "to recipe. Click empty space to skip a slot.", String.valueOf(ChatColor.GRAY) + "Yellow highlight shows current slot.");
        menu.setItem(49, instructionsButton);
        ItemStack highlightItem = RecipeCreateGUI.createGuiItem(Material.YELLOW_STAINED_GLASS_PANE, String.valueOf(ChatColor.YELLOW) + "Current Selection", String.valueOf(ChatColor.GRAY) + "Click an item in your inventory", String.valueOf(ChatColor.GRAY) + "to place it here");
        menu.setItem(10, highlightItem);
        for (int i = 0; i < 54; ++i) {
            if (RecipeCreateGUI.isInCraftingGrid(i) || i == 24 || menu.getItem(i) != null) continue;
            menu.setItem(i, RecipeCreateGUI.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
        }
        player.openInventory(menu);
    }

    public static void openShapelessRecipeMenu(Player player) {
        Inventory menu = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shapeless Recipe"));
        ItemStack gridBorder = RecipeCreateGUI.createGuiItem(Material.PURPLE_STAINED_GLASS_PANE, String.valueOf(ChatColor.LIGHT_PURPLE) + "Ingredients", String.valueOf(ChatColor.GRAY) + "Place ingredients here (order doesn't matter)");
        menu.setItem(1, gridBorder);
        menu.setItem(2, gridBorder);
        menu.setItem(3, gridBorder);
        menu.setItem(9, gridBorder);
        menu.setItem(18, gridBorder);
        menu.setItem(27, gridBorder);
        menu.setItem(13, gridBorder);
        menu.setItem(22, gridBorder);
        menu.setItem(31, gridBorder);
        menu.setItem(37, gridBorder);
        menu.setItem(38, gridBorder);
        menu.setItem(39, gridBorder);
        ItemStack arrowItem = RecipeCreateGUI.createGuiItem(Material.ARROW, String.valueOf(ChatColor.WHITE) + "\u2192", String.valueOf(ChatColor.GRAY) + "Creates");
        menu.setItem(23, arrowItem);
        ItemStack nameInput = RecipeCreateGUI.createGuiItem(Material.NAME_TAG, String.valueOf(ChatColor.YELLOW) + "Recipe Name", String.valueOf(ChatColor.GRAY) + "Click to set the recipe name");
        menu.setItem(42, nameInput);
        ItemStack maxCraftsInput = RecipeCreateGUI.createGuiItem(Material.HOPPER, String.valueOf(ChatColor.GOLD) + "Max Crafts: Unlimited", String.valueOf(ChatColor.GRAY) + "Click to set usage limit", String.valueOf(ChatColor.GRAY) + "Leave unlimited or set a number", String.valueOf(ChatColor.AQUA) + "Examples:", String.valueOf(ChatColor.WHITE) + "\u2022 1 = Only one person can craft", String.valueOf(ChatColor.WHITE) + "\u2022 5 = Can be crafted 5 times total", String.valueOf(ChatColor.WHITE) + "\u2022 Unlimited = No limit");
        menu.setItem(43, maxCraftsInput);
        ItemStack saveButton = RecipeCreateGUI.createGuiItem(Material.EMERALD_BLOCK, String.valueOf(ChatColor.GREEN) + "Save Recipe", String.valueOf(ChatColor.GRAY) + "Click to save this recipe");
        menu.setItem(51, saveButton);
        ItemStack cancelButton = RecipeCreateGUI.createGuiItem(Material.REDSTONE_BLOCK, String.valueOf(ChatColor.RED) + "Cancel", String.valueOf(ChatColor.GRAY) + "Click to cancel");
        menu.setItem(52, cancelButton);
        ItemStack instructionsButton = RecipeCreateGUI.createGuiItem(Material.PAPER, String.valueOf(ChatColor.AQUA) + "Instructions", String.valueOf(ChatColor.GRAY) + "Click items in your inventory to add", String.valueOf(ChatColor.GRAY) + "to recipe. Click empty space to skip a slot.", String.valueOf(ChatColor.GRAY) + "Yellow highlight shows current slot.");
        menu.setItem(49, instructionsButton);
        ItemStack highlightItem = RecipeCreateGUI.createGuiItem(Material.YELLOW_STAINED_GLASS_PANE, String.valueOf(ChatColor.YELLOW) + "Current Selection", String.valueOf(ChatColor.GRAY) + "Click an item in your inventory", String.valueOf(ChatColor.GRAY) + "to place it here");
        menu.setItem(10, highlightItem);
        for (int i = 0; i < 54; ++i) {
            if (RecipeCreateGUI.isInCraftingGrid(i) || i == 24 || menu.getItem(i) != null) continue;
            menu.setItem(i, RecipeCreateGUI.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]));
        }
        player.openInventory(menu);
    }

    public static void updateMaxCraftsButton(Player player, int maxCrafts) {
        Inventory inv = player.getOpenInventory().getTopInventory();
        String title = player.getOpenInventory().getTitle();
        if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shaped Recipe") || title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shapeless Recipe")) {
            ItemStack maxCraftsButton = maxCrafts <= 0 ? RecipeCreateGUI.createGuiItem(Material.HOPPER, String.valueOf(ChatColor.GOLD) + "Max Crafts: Unlimited", String.valueOf(ChatColor.GRAY) + "Click to set usage limit", String.valueOf(ChatColor.GRAY) + "Currently: Unlimited uses", String.valueOf(ChatColor.AQUA) + "Examples:", String.valueOf(ChatColor.WHITE) + "\u2022 1 = Only one person can craft", String.valueOf(ChatColor.WHITE) + "\u2022 5 = Can be crafted 5 times total") : RecipeCreateGUI.createGuiItem(Material.HOPPER, String.valueOf(ChatColor.GOLD) + "Max Crafts: " + maxCrafts, String.valueOf(ChatColor.GRAY) + "Click to change usage limit", String.valueOf(ChatColor.GRAY) + "Currently: " + maxCrafts + " total uses", String.valueOf(ChatColor.AQUA) + "Examples:", String.valueOf(ChatColor.WHITE) + "\u2022 1 = Only one person can craft", String.valueOf(ChatColor.WHITE) + "\u2022 0 = Unlimited uses");
            inv.setItem(43, maxCraftsButton);
        }
    }

    public static void openNameInputMenu(Player player) {
        Inventory menu = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Set Name"));
        ItemStack instructionsItem = RecipeCreateGUI.createGuiItem(Material.PAPER, String.valueOf(ChatColor.YELLOW) + "Enter Recipe Name", String.valueOf(ChatColor.GRAY) + "Type the name in chat", String.valueOf(ChatColor.GRAY) + "Names must be unique and lowercase");
        ItemStack cancelButton = RecipeCreateGUI.createGuiItem(Material.REDSTONE_BLOCK, String.valueOf(ChatColor.RED) + "Cancel", String.valueOf(ChatColor.GRAY) + "Click to cancel");
        menu.setItem(4, instructionsItem);
        menu.setItem(8, cancelButton);
        player.openInventory(menu);
    }

    private static ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    private static boolean isInCraftingGrid(int slot) {
        int row = slot / 9;
        int col = slot % 9;
        return row >= 1 && row <= 3 && col >= 1 && col <= 3;
    }
}

