/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.recipecreate;

import com.yourname.recipecreate.RecipeCraftListener;
import com.yourname.recipecreate.RecipeCreateGUI;
import com.yourname.recipecreate.RecipeCreateMenuHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RecipeCreateX
extends JavaPlugin {
    private FileConfiguration config;
    private final Map<UUID, RecipeSession> recipeSessions = new HashMap<UUID, RecipeSession>();
    private final List<NamespacedKey> customRecipes = new ArrayList<NamespacedKey>();
    private boolean itemMakerXEnabled = false;
    private final Map<String, Integer> recipeCraftCounts = new HashMap<String, Integer>();
    private final Map<String, Integer> recipeMaxCrafts = new HashMap<String, Integer>();
    private final Map<String, UUID> recipeCraftedBy = new HashMap<String, UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getCommand("recipecreate").setExecutor((CommandExecutor)new RecipeCreateCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new RecipeCreateMenuHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RecipeCraftListener(this), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("ItemMakerX") != null) {
            this.itemMakerXEnabled = true;
            this.getLogger().info("ItemMakerX detected! Integration enabled.");
        }
        this.loadRecipes();
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "RecipeCreateX has been enabled!");
    }

    public void onDisable() {
        for (NamespacedKey key : this.customRecipes) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        this.getLogger().info(String.valueOf(ChatColor.RED) + "RecipeCreateX has been disabled!");
    }

    public Map<UUID, RecipeSession> getRecipeSessions() {
        return this.recipeSessions;
    }

    public boolean isItemMakerXEnabled() {
        return this.itemMakerXEnabled;
    }

    public boolean canCraftRecipe(String recipeName, Player player) {
        if (!this.getConfig().getBoolean("settings.enable-usage-limits", true)) {
            return true;
        }
        if (!this.recipeMaxCrafts.containsKey(recipeName)) {
            return true;
        }
        int maxCrafts = this.recipeMaxCrafts.get(recipeName);
        int currentCrafts = this.recipeCraftCounts.getOrDefault(recipeName, 0);
        if (maxCrafts == 1 && currentCrafts >= 1) {
            UUID firstCrafter = this.recipeCraftedBy.get(recipeName);
            return firstCrafter != null && firstCrafter.equals(player.getUniqueId());
        }
        return currentCrafts < maxCrafts;
    }

    public String getCraftBlockReason(String recipeName, Player player) {
        UUID firstCrafter;
        if (!this.recipeMaxCrafts.containsKey(recipeName)) {
            return null;
        }
        int maxCrafts = this.recipeMaxCrafts.get(recipeName);
        int currentCrafts = this.recipeCraftCounts.getOrDefault(recipeName, 0);
        if (maxCrafts == 1 && currentCrafts >= 1 && (firstCrafter = this.recipeCraftedBy.get(recipeName)) != null && !firstCrafter.equals(player.getUniqueId())) {
            String firstCrafterName = this.getServer().getOfflinePlayer(firstCrafter).getName();
            return this.getConfig().getString("messages.recipe-used-by-other", "&cThis recipe has already been used by {player}!").replace("{player}", firstCrafterName);
        }
        if (currentCrafts >= maxCrafts) {
            return this.getConfig().getString("messages.recipe-exhausted", "&cThis recipe has reached its maximum usage limit!");
        }
        return null;
    }

    public void recordRecipeCraft(String recipeName, Player player) {
        int currentCrafts = this.recipeCraftCounts.getOrDefault(recipeName, 0);
        this.recipeCraftCounts.put(recipeName, currentCrafts + 1);
        if (currentCrafts == 0) {
            this.recipeCraftedBy.put(recipeName, player.getUniqueId());
        }
        this.getConfig().set("recipe-usage." + recipeName + ".crafts", (Object)(currentCrafts + 1));
        if (this.recipeCraftedBy.containsKey(recipeName)) {
            this.getConfig().set("recipe-usage." + recipeName + ".first-crafter", (Object)this.recipeCraftedBy.get(recipeName).toString());
        }
        this.saveConfig();
        this.sendCraftFeedback(recipeName, player);
    }

    private void sendCraftFeedback(String recipeName, Player player) {
        int currentCrafts;
        if (!this.recipeMaxCrafts.containsKey(recipeName)) {
            return;
        }
        int maxCrafts = this.recipeMaxCrafts.get(recipeName);
        int remaining = maxCrafts - (currentCrafts = this.recipeCraftCounts.get(recipeName).intValue());
        if (remaining > 0) {
            String message = this.getConfig().getString("messages.recipe-crafted-remaining", "&eRecipe crafted! {remaining} uses remaining.").replace("{remaining}", String.valueOf(remaining));
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        } else {
            String message = this.getConfig().getString("messages.recipe-crafted-last", "&eRecipe crafted! This was the last use of this recipe.");
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
            if (this.getConfig().getBoolean("settings.announce-recipe-depletion", true)) {
                String broadcastMessage = this.getConfig().getString("messages.recipe-depleted-broadcast", "&6{player} has used the last craft of recipe: {recipe}").replace("{player}", player.getName()).replace("{recipe}", recipeName);
                this.getServer().broadcastMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)broadcastMessage));
            }
        }
    }

    public int getRemainingCrafts(String recipeName) {
        if (!this.recipeMaxCrafts.containsKey(recipeName)) {
            return -1;
        }
        int maxCrafts = this.recipeMaxCrafts.get(recipeName);
        int currentCrafts = this.recipeCraftCounts.getOrDefault(recipeName, 0);
        return Math.max(0, maxCrafts - currentCrafts);
    }

    public void saveRecipe(String recipeName, RecipeType type, ItemStack resultItem, Map<Character, Material> ingredients, String[] shape, int maxCrafts) {
        this.getConfig().set("recipes." + recipeName + ".type", (Object)type.name());
        this.getConfig().set("recipes." + recipeName + ".result", (Object)resultItem);
        for (Map.Entry<Character, Material> entry : ingredients.entrySet()) {
            this.getConfig().set("recipes." + recipeName + ".ingredients." + String.valueOf(entry.getKey()), (Object)entry.getValue().name());
        }
        if (type == RecipeType.SHAPED) {
            this.getConfig().set("recipes." + recipeName + ".shape", Arrays.asList(shape));
        }
        if (maxCrafts > 0) {
            this.getConfig().set("recipes." + recipeName + ".max-crafts", (Object)maxCrafts);
            this.recipeMaxCrafts.put(recipeName, maxCrafts);
        }
        this.saveConfig();
    }

    public void loadRecipes() {
        ConfigurationSection recipesSection;
        if (this.getConfig().contains("recipes") && (recipesSection = this.getConfig().getConfigurationSection("recipes")) != null) {
            for (String key : recipesSection.getKeys(false)) {
                try {
                    String typeStr = this.getConfig().getString("recipes." + key + ".type");
                    RecipeType type = RecipeType.valueOf(typeStr);
                    ItemStack result = this.getConfig().getItemStack("recipes." + key + ".result");
                    HashMap<Character, Material> ingredients = new HashMap<Character, Material>();
                    ConfigurationSection ingredientsSection = this.getConfig().getConfigurationSection("recipes." + key + ".ingredients");
                    if (ingredientsSection != null) {
                        for (String charKey : ingredientsSection.getKeys(false)) {
                            char c = charKey.charAt(0);
                            String materialName = ingredientsSection.getString(charKey);
                            Material material = Material.valueOf((String)materialName);
                            ingredients.put(Character.valueOf(c), material);
                        }
                    }
                    if (this.getConfig().contains("recipes." + key + ".max-crafts")) {
                        int maxCrafts = this.getConfig().getInt("recipes." + key + ".max-crafts");
                        this.recipeMaxCrafts.put(key, maxCrafts);
                    }
                    if (this.getConfig().contains("recipe-usage." + key)) {
                        int crafts = this.getConfig().getInt("recipe-usage." + key + ".crafts", 0);
                        this.recipeCraftCounts.put(key, crafts);
                        String firstCrafterStr = this.getConfig().getString("recipe-usage." + key + ".first-crafter");
                        if (firstCrafterStr != null) {
                            this.recipeCraftedBy.put(key, UUID.fromString(firstCrafterStr));
                        }
                    }
                    if (type == RecipeType.SHAPED) {
                        List shape = this.getConfig().getStringList("recipes." + key + ".shape");
                        this.registerShapedRecipe(key, result, ingredients, shape.toArray(new String[0]));
                    } else {
                        this.registerShapelessRecipe(key, result, ingredients);
                    }
                    String maxCraftsInfo = this.recipeMaxCrafts.containsKey(key) ? " (max crafts: " + String.valueOf(this.recipeMaxCrafts.get(key)) + ")" : " (unlimited)";
                    this.getLogger().info("Loaded recipe: " + key + maxCraftsInfo);
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to load recipe: " + key + " - " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    public void registerShapedRecipe(String key, ItemStack result, Map<Character, Material> ingredients, String[] shape) {
        ArrayList<String> nonEmptyRows = new ArrayList<String>();
        for (String row : shape) {
            if (row.trim().isEmpty()) continue;
            nonEmptyRows.add(row);
        }
        if (nonEmptyRows.isEmpty()) {
            throw new IllegalArgumentException("Recipe has no pattern!");
        }
        NamespacedKey recipeKey = new NamespacedKey((Plugin)this, key);
        ShapedRecipe recipe = new ShapedRecipe(recipeKey, result);
        recipe.shape(nonEmptyRows.toArray(new String[0]));
        for (Map.Entry<Character, Material> entry : ingredients.entrySet()) {
            if (entry.getKey().charValue() == ' ') continue;
            recipe.setIngredient(entry.getKey().charValue(), entry.getValue());
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.customRecipes.add(recipeKey);
        this.getLogger().info("Registered shaped recipe: " + key);
    }

    public void registerShapelessRecipe(String key, ItemStack result, Map<Character, Material> ingredients) {
        NamespacedKey recipeKey = new NamespacedKey((Plugin)this, key);
        ShapelessRecipe recipe = new ShapelessRecipe(recipeKey, result);
        for (Material material : ingredients.values()) {
            recipe.addIngredient(material);
        }
        Bukkit.addRecipe((Recipe)recipe);
        this.customRecipes.add(recipeKey);
        this.getLogger().info("Registered shapeless recipe: " + key);
    }

    public Map<String, Integer> getRecipeMaxCrafts() {
        return this.recipeMaxCrafts;
    }

    public Map<String, Integer> getRecipeCraftCounts() {
        return this.recipeCraftCounts;
    }

    public Map<String, UUID> getRecipeCraftedBy() {
        return this.recipeCraftedBy;
    }

    public class RecipeCreateCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("recipecreate.use")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length == 0) {
                RecipeCreateGUI.openMainMenu(player);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "shaped": {
                    RecipeCreateX.this.recipeSessions.put(player.getUniqueId(), new RecipeSession(RecipeCreateX.this, RecipeType.SHAPED));
                    RecipeCreateGUI.openShapedRecipeMenu(player);
                    return true;
                }
                case "shapeless": {
                    RecipeCreateX.this.recipeSessions.put(player.getUniqueId(), new RecipeSession(RecipeCreateX.this, RecipeType.SHAPELESS));
                    RecipeCreateGUI.openShapelessRecipeMenu(player);
                    return true;
                }
                case "list": {
                    this.listRecipes(player);
                    return true;
                }
                case "delete": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /recipecreate delete <name>");
                        return true;
                    }
                    this.deleteRecipe(player, args[1]);
                    return true;
                }
                case "status": {
                    if (args.length < 2) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /recipecreate status <recipe_name>");
                        return true;
                    }
                    this.showRecipeStatus(player, args[1]);
                    return true;
                }
            }
            this.sendHelpMessage(player);
            return true;
        }

        private void listRecipes(Player player) {
            if (!RecipeCreateX.this.config.contains("recipes") || RecipeCreateX.this.config.getConfigurationSection("recipes").getKeys(false).isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "No custom recipes found.");
                return;
            }
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "==== Custom Recipes ====");
            for (String name : RecipeCreateX.this.config.getConfigurationSection("recipes").getKeys(false)) {
                int remaining;
                ConfigurationSection recipe = RecipeCreateX.this.config.getConfigurationSection("recipes." + name);
                String type = recipe.getString("type");
                String result = recipe.getString("result.material");
                int maxCrafts = RecipeCreateX.this.recipeMaxCrafts.getOrDefault(name, -1);
                int currentCrafts = RecipeCreateX.this.recipeCraftCounts.getOrDefault(name, 0);
                String usageInfo = maxCrafts == -1 ? String.valueOf(ChatColor.GREEN) + "Unlimited" : ((remaining = maxCrafts - currentCrafts) <= 0 ? String.valueOf(ChatColor.RED) + "Exhausted (" + currentCrafts + "/" + maxCrafts + ")" : String.valueOf(ChatColor.YELLOW) + String.valueOf(remaining) + "/" + maxCrafts + " left");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + name + String.valueOf(ChatColor.WHITE) + " - " + String.valueOf(ChatColor.GREEN) + type + String.valueOf(ChatColor.WHITE) + " - " + String.valueOf(ChatColor.AQUA) + result + String.valueOf(ChatColor.WHITE) + " - " + usageInfo);
            }
        }

        private void deleteRecipe(Player player, String name) {
            if (!RecipeCreateX.this.config.contains("recipes." + name)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Recipe not found: " + name);
                return;
            }
            NamespacedKey key = new NamespacedKey((Plugin)RecipeCreateX.this, name);
            Bukkit.removeRecipe((NamespacedKey)key);
            RecipeCreateX.this.customRecipes.remove(key);
            RecipeCreateX.this.recipeMaxCrafts.remove(name);
            RecipeCreateX.this.recipeCraftCounts.remove(name);
            RecipeCreateX.this.recipeCraftedBy.remove(name);
            RecipeCreateX.this.config.set("recipes." + name, null);
            RecipeCreateX.this.config.set("recipe-usage." + name, null);
            RecipeCreateX.this.saveConfig();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Recipe deleted: " + name);
        }

        private void showRecipeStatus(Player player, String recipeName) {
            if (!RecipeCreateX.this.config.contains("recipes." + recipeName)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Recipe not found: " + recipeName);
                return;
            }
            int maxCrafts = RecipeCreateX.this.recipeMaxCrafts.getOrDefault(recipeName, -1);
            int currentCrafts = RecipeCreateX.this.recipeCraftCounts.getOrDefault(recipeName, 0);
            UUID firstCrafter = RecipeCreateX.this.recipeCraftedBy.get(recipeName);
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Recipe Status: " + recipeName + " ===");
            if (maxCrafts == -1) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Usage limit: Unlimited");
            } else {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Usage limit: " + maxCrafts);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Times crafted: " + currentCrafts);
                player.sendMessage(String.valueOf(ChatColor.AQUA) + "Remaining uses: " + Math.max(0, maxCrafts - currentCrafts));
            }
            if (firstCrafter != null) {
                String firstCrafterName = RecipeCreateX.this.getServer().getOfflinePlayer(firstCrafter).getName();
                player.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + "First crafted by: " + firstCrafterName);
            } else if (currentCrafts == 0) {
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Never been crafted");
            }
        }

        private void sendHelpMessage(Player player) {
            player.sendMessage(String.valueOf(ChatColor.GOLD) + "===== RecipeCreateX Commands =====");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/recipecreate" + String.valueOf(ChatColor.WHITE) + " - Open the main GUI");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/recipecreate shaped" + String.valueOf(ChatColor.WHITE) + " - Create a shaped recipe");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/recipecreate shapeless" + String.valueOf(ChatColor.WHITE) + " - Create a shapeless recipe");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/recipecreate list" + String.valueOf(ChatColor.WHITE) + " - List all custom recipes");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/recipecreate delete <name>" + String.valueOf(ChatColor.WHITE) + " - Delete a custom recipe");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/recipecreate status <name>" + String.valueOf(ChatColor.WHITE) + " - Check recipe usage status");
        }
    }

    public static enum RecipeType {
        SHAPED,
        SHAPELESS;

    }

    public class RecipeSession {
        private RecipeType type;
        private String name;
        private int currentSlotIndex = -1;
        private ItemStack resultItem;
        private Map<Integer, ItemStack> ingredientItems = new HashMap<Integer, ItemStack>();
        private boolean nameInputMode = false;
        private int maxCrafts = -1;

        public RecipeSession(RecipeCreateX this$0, RecipeType type) {
            this.type = type;
        }

        public RecipeType getType() {
            return this.type;
        }

        public void setType(RecipeType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getCurrentSlotIndex() {
            return this.currentSlotIndex;
        }

        public void setCurrentSlotIndex(int currentSlotIndex) {
            this.currentSlotIndex = currentSlotIndex;
        }

        public ItemStack getResultItem() {
            return this.resultItem;
        }

        public void setResultItem(ItemStack resultItem) {
            this.resultItem = resultItem;
        }

        public Map<Integer, ItemStack> getIngredientItems() {
            return this.ingredientItems;
        }

        public void setIngredientItem(int slot, ItemStack item) {
            this.ingredientItems.put(slot, item);
        }

        public boolean isNameInputMode() {
            return this.nameInputMode;
        }

        public void setNameInputMode(boolean nameInputMode) {
            this.nameInputMode = nameInputMode;
        }

        public int getMaxCrafts() {
            return this.maxCrafts;
        }

        public void setMaxCrafts(int maxCrafts) {
            this.maxCrafts = maxCrafts;
        }
    }
}

