/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.recipecreate;

import com.yourname.recipecreate.RecipeCreateGUI;
import com.yourname.recipecreate.RecipeCreateX;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipeCreateMenuHandler
implements Listener {
    private final RecipeCreateX plugin;
    private final Map<UUID, Boolean> awaitingNameInput = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> awaitingMaxCraftsInput = new HashMap<UUID, Boolean>();

    public RecipeCreateMenuHandler(RecipeCreateX plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (title.startsWith(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX")) {
            if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Main Menu")) {
                event.setCancelled(true);
                if (event.getRawSlot() == 11) {
                    RecipeCreateGUI.openShapedRecipeMenu(player);
                    RecipeCreateX recipeCreateX = this.plugin;
                    Objects.requireNonNull(recipeCreateX);
                    RecipeCreateX.RecipeSession session = new RecipeCreateX.RecipeSession(recipeCreateX, RecipeCreateX.RecipeType.SHAPED);
                    session.setCurrentSlotIndex(0);
                    this.plugin.getRecipeSessions().put(player.getUniqueId(), session);
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                } else if (event.getRawSlot() == 13) {
                    RecipeCreateGUI.openShapelessRecipeMenu(player);
                    RecipeCreateX recipeCreateX = this.plugin;
                    Objects.requireNonNull(recipeCreateX);
                    RecipeCreateX.RecipeSession session = new RecipeCreateX.RecipeSession(recipeCreateX, RecipeCreateX.RecipeType.SHAPELESS);
                    session.setCurrentSlotIndex(0);
                    this.plugin.getRecipeSessions().put(player.getUniqueId(), session);
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                } else if (event.getRawSlot() == 15) {
                    player.closeInventory();
                    this.plugin.getCommand("recipecreate").getExecutor().onCommand((CommandSender)player, null, "recipecreate", new String[]{"list"});
                } else if (event.getRawSlot() == 22) {
                    player.closeInventory();
                    this.plugin.getCommand("recipecreate").getExecutor().onCommand((CommandSender)player, null, "recipecreate", new String[]{"help"});
                } else if (event.getRawSlot() == 26) {
                    player.closeInventory();
                }
            } else if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shaped Recipe") || title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shapeless Recipe")) {
                UUID playerId = player.getUniqueId();
                RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(playerId);
                if (session == null) {
                    RecipeCreateX recipeCreateX = this.plugin;
                    Objects.requireNonNull(recipeCreateX);
                    session = new RecipeCreateX.RecipeSession(recipeCreateX, title.contains("Shaped") ? RecipeCreateX.RecipeType.SHAPED : RecipeCreateX.RecipeType.SHAPELESS);
                    this.plugin.getRecipeSessions().put(playerId, session);
                }
                if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) {
                    event.setCancelled(true);
                    ItemStack clickedItem = event.getCurrentItem();
                    if (clickedItem != null && clickedItem.getType() != Material.AIR) {
                        int[] craftingSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30, 24};
                        int currentSlotIndex = session.getCurrentSlotIndex();
                        if (currentSlotIndex == -1) {
                            currentSlotIndex = 0;
                            session.setCurrentSlotIndex(currentSlotIndex);
                        }
                        int currentSlot = craftingSlots[currentSlotIndex];
                        ItemStack itemToPlace = clickedItem.clone();
                        itemToPlace.setAmount(1);
                        event.getView().getTopInventory().setItem(currentSlot, itemToPlace);
                        if (currentSlot == 24) {
                            session.setResultItem(itemToPlace);
                        } else {
                            session.setIngredientItem(currentSlot, itemToPlace);
                        }
                        if (currentSlotIndex < craftingSlots.length - 1) {
                            session.setCurrentSlotIndex(++currentSlotIndex);
                            this.highlightCurrentSlot(player);
                        } else {
                            player.closeInventory();
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please type a name for your recipe in chat:");
                            this.awaitingNameInput.put(player.getUniqueId(), true);
                            session.setNameInputMode(true);
                        }
                    } else {
                        int[] craftingSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30, 24};
                        int currentSlotIndex = session.getCurrentSlotIndex();
                        if (currentSlotIndex < craftingSlots.length - 1) {
                            session.setCurrentSlotIndex(++currentSlotIndex);
                            this.highlightCurrentSlot(player);
                        } else {
                            player.closeInventory();
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please type a name for your recipe in chat:");
                            this.awaitingNameInput.put(player.getUniqueId(), true);
                            session.setNameInputMode(true);
                        }
                    }
                    return;
                }
                if (this.isInCraftingGrid(event.getRawSlot()) || this.isResultSlot(event.getRawSlot())) {
                    event.setCancelled(false);
                    int slotRaw = event.getRawSlot();
                    RecipeCreateX.RecipeSession finalSession = session;
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        ItemStack item = player.getOpenInventory().getItem(slotRaw);
                        if (item != null && item.getType() != Material.AIR && !item.getType().name().contains("STAINED_GLASS_PANE")) {
                            if (this.isResultSlot(slotRaw)) {
                                finalSession.setResultItem(item.clone());
                            } else {
                                finalSession.setIngredientItem(slotRaw, item.clone());
                            }
                        } else if (this.isResultSlot(slotRaw)) {
                            finalSession.setResultItem(null);
                        } else {
                            finalSession.getIngredientItems().remove(slotRaw);
                        }
                    }, 1L);
                    int[] craftingSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30, 24};
                    for (int i = 0; i < craftingSlots.length; ++i) {
                        if (event.getRawSlot() != craftingSlots[i]) continue;
                        session.setCurrentSlotIndex(i);
                        break;
                    }
                } else {
                    event.setCancelled(true);
                    if (event.getRawSlot() == 42) {
                        player.closeInventory();
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please type a name for your recipe in chat:");
                        this.awaitingNameInput.put(player.getUniqueId(), true);
                        session.setNameInputMode(true);
                    } else if (event.getRawSlot() == 43) {
                        player.closeInventory();
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please type the maximum number of times this recipe can be crafted:");
                        player.sendMessage(String.valueOf(ChatColor.GRAY) + "Type '0' or 'unlimited' for no limit, or type 'cancel' to cancel.");
                        this.awaitingMaxCraftsInput.put(player.getUniqueId(), true);
                        session.setNameInputMode(true);
                    } else if (event.getRawSlot() == 51) {
                        this.saveRecipe(player);
                    } else if (event.getRawSlot() == 52) {
                        player.closeInventory();
                        RecipeCreateGUI.openMainMenu(player);
                    }
                }
            } else if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Set Name")) {
                event.setCancelled(true);
                if (event.getRawSlot() == 8) {
                    player.closeInventory();
                    this.awaitingNameInput.remove(player.getUniqueId());
                    this.awaitingMaxCraftsInput.remove(player.getUniqueId());
                    RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(player.getUniqueId());
                    if (session != null) {
                        session.setNameInputMode(false);
                        if (session.getType() == RecipeCreateX.RecipeType.SHAPED) {
                            RecipeCreateGUI.openShapedRecipeMenu(player);
                        } else {
                            RecipeCreateGUI.openShapelessRecipeMenu(player);
                        }
                        RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                    } else {
                        RecipeCreateGUI.openMainMenu(player);
                    }
                }
            }
        }
    }

    private void highlightCurrentSlot(Player player) {
        UUID playerId = player.getUniqueId();
        RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(playerId);
        if (session == null || player.getOpenInventory() == null) {
            return;
        }
        String title = player.getOpenInventory().getTitle();
        if (!title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shaped Recipe") && !title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shapeless Recipe")) {
            return;
        }
        int[] craftingSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30, 24};
        int currentSlotIndex = session.getCurrentSlotIndex();
        if (currentSlotIndex >= craftingSlots.length) {
            currentSlotIndex = 0;
            session.setCurrentSlotIndex(currentSlotIndex);
        }
        int slotToHighlight = craftingSlots[currentSlotIndex];
        for (int i = 0; i < craftingSlots.length; ++i) {
            int slot = craftingSlots[i];
            ItemStack currentItem = player.getOpenInventory().getItem(slot);
            if (currentItem != null && currentItem.getType() != Material.AIR && !currentItem.getType().name().contains("STAINED_GLASS_PANE")) continue;
            if (slot == slotToHighlight) {
                player.getOpenInventory().setItem(slot, this.createHighlightItem());
                continue;
            }
            if (currentItem == null || currentItem.getItemMeta() == null || !currentItem.getItemMeta().getDisplayName().equals(String.valueOf(ChatColor.YELLOW) + "Current Selection")) continue;
            player.getOpenInventory().setItem(slot, null);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (title.startsWith(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX")) {
            event.setCancelled(true);
            if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shaped Recipe") || title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shapeless Recipe")) {
                boolean allSlotsValid = true;
                Iterator iterator = event.getRawSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (this.isInCraftingGrid(slot) || this.isResultSlot(slot)) continue;
                    allSlotsValid = false;
                    break;
                }
                if (allSlotsValid) {
                    event.setCancelled(false);
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        RecipeCreateX.RecipeSession session;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Set Name")) {
            this.awaitingNameInput.remove(player.getUniqueId());
            this.awaitingMaxCraftsInput.remove(player.getUniqueId());
            session = this.plugin.getRecipeSessions().get(player.getUniqueId());
            if (session != null) {
                session.setNameInputMode(false);
            }
        }
        if (title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shaped Recipe") || title.equals(String.valueOf(ChatColor.DARK_GREEN) + "RecipeCreateX - Shapeless Recipe")) {
            ItemStack item;
            int slot;
            int col;
            session = this.plugin.getRecipeSessions().get(player.getUniqueId());
            if (session != null && !session.isNameInputMode()) {
                for (int row = 0; row < 3; ++row) {
                    for (col = 0; col < 3; ++col) {
                        slot = 10 + col + row * 9;
                        item = event.getInventory().getItem(slot);
                        if (item == null || item.getType() == Material.AIR || item.getType().name().contains("STAINED_GLASS_PANE") || item.getType() == Material.BARRIER) continue;
                        session.setIngredientItem(slot, item.clone());
                    }
                }
                ItemStack resultItem = event.getInventory().getItem(24);
                if (resultItem != null && resultItem.getType() != Material.AIR && resultItem.getType() != Material.BARRIER && !resultItem.getType().name().contains("STAINED_GLASS_PANE")) {
                    session.setResultItem(resultItem.clone());
                }
            }
            for (int row = 0; row < 3; ++row) {
                for (col = 0; col < 3; ++col) {
                    slot = 10 + col + row * 9;
                    item = event.getInventory().getItem(slot);
                    if (item == null || item.getType() == Material.AIR || item.getType().name().contains("STAINED_GLASS_PANE") || item.getType() == Material.BARRIER) continue;
                    player.getInventory().addItem(new ItemStack[]{item}).values().forEach(leftover -> player.getWorld().dropItem(player.getLocation(), leftover));
                }
            }
            ItemStack resultItem = event.getInventory().getItem(24);
            if (resultItem != null && resultItem.getType() != Material.AIR && resultItem.getType() != Material.BARRIER && !resultItem.getType().name().contains("STAINED_GLASS_PANE")) {
                player.getInventory().addItem(new ItemStack[]{resultItem}).values().forEach(leftover -> player.getWorld().dropItem(player.getLocation(), leftover));
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.awaitingNameInput.containsKey(player.getUniqueId()) && this.awaitingNameInput.get(player.getUniqueId()).booleanValue()) {
            event.setCancelled(true);
            String recipeName = event.getMessage();
            if (recipeName.equalsIgnoreCase("cancel")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Recipe name input cancelled.");
                this.awaitingNameInput.remove(player.getUniqueId());
                RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(player.getUniqueId());
                if (session != null) {
                    session.setNameInputMode(false);
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (session.getType() == RecipeCreateX.RecipeType.SHAPED) {
                            RecipeCreateGUI.openShapedRecipeMenu(player);
                        } else {
                            RecipeCreateGUI.openShapelessRecipeMenu(player);
                        }
                        RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                    });
                }
                return;
            }
            recipeName = recipeName.toLowerCase().replaceAll("\\s+", "_");
            if (this.plugin.getConfig().contains("recipes." + recipeName)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "A recipe with that name already exists! Please choose another name.");
                return;
            }
            RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(player.getUniqueId());
            if (session != null) {
                session.setName(recipeName);
                this.awaitingNameInput.remove(player.getUniqueId());
                session.setNameInputMode(false);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Recipe name set to: " + recipeName);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (session.getType() == RecipeCreateX.RecipeType.SHAPED) {
                        RecipeCreateGUI.openShapedRecipeMenu(player);
                    } else {
                        RecipeCreateGUI.openShapelessRecipeMenu(player);
                    }
                    RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                });
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error: No recipe session found.");
                this.awaitingNameInput.remove(player.getUniqueId());
            }
        } else if (this.awaitingMaxCraftsInput.containsKey(player.getUniqueId()) && this.awaitingMaxCraftsInput.get(player.getUniqueId()).booleanValue()) {
            event.setCancelled(true);
            String input = event.getMessage();
            if (input.equalsIgnoreCase("cancel")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Max crafts input cancelled.");
                this.awaitingMaxCraftsInput.remove(player.getUniqueId());
                RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(player.getUniqueId());
                if (session != null) {
                    session.setNameInputMode(false);
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (session.getType() == RecipeCreateX.RecipeType.SHAPED) {
                            RecipeCreateGUI.openShapedRecipeMenu(player);
                        } else {
                            RecipeCreateGUI.openShapelessRecipeMenu(player);
                        }
                        RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                    });
                }
                return;
            }
            int maxCrafts = -1;
            if (input.equalsIgnoreCase("unlimited") || input.equals("0")) {
                maxCrafts = -1;
            } else {
                try {
                    maxCrafts = Integer.parseInt(input);
                    if (maxCrafts < 0) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Number must be positive! Use 0 for unlimited.");
                        return;
                    }
                    if (maxCrafts == 0) {
                        maxCrafts = -1;
                    }
                }
                catch (NumberFormatException e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number! Please enter a valid number, 'unlimited', or 'cancel'.");
                    return;
                }
            }
            RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(player.getUniqueId());
            if (session != null) {
                session.setMaxCrafts(maxCrafts);
                this.awaitingMaxCraftsInput.remove(player.getUniqueId());
                session.setNameInputMode(false);
                if (maxCrafts == -1) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Max crafts set to: Unlimited");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Max crafts set to: " + maxCrafts);
                }
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (session.getType() == RecipeCreateX.RecipeType.SHAPED) {
                        RecipeCreateGUI.openShapedRecipeMenu(player);
                    } else {
                        RecipeCreateGUI.openShapelessRecipeMenu(player);
                    }
                    RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                });
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Error: No recipe session found.");
                this.awaitingMaxCraftsInput.remove(player.getUniqueId());
            }
        }
    }

    private ItemStack createHighlightItem() {
        ItemStack highlight = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE, 1);
        ItemMeta meta = highlight.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Current Selection");
        meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Click an item in your inventory", String.valueOf(ChatColor.GRAY) + "to place it here"));
        highlight.setItemMeta(meta);
        return highlight;
    }

    private void saveRecipe(Player player) {
        UUID playerId = player.getUniqueId();
        RecipeCreateX.RecipeSession session = this.plugin.getRecipeSessions().get(playerId);
        if (session == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: No recipe session found.");
            return;
        }
        RecipeCreateX.RecipeType type = session.getType();
        ItemStack resultItem = session.getResultItem();
        if (resultItem == null || resultItem.getType() == Material.AIR || resultItem.getType() == Material.BARRIER || resultItem.getType().name().contains("STAINED_GLASS_PANE")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Please add a result item!");
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (type == RecipeCreateX.RecipeType.SHAPED) {
                    RecipeCreateGUI.openShapedRecipeMenu(player);
                } else {
                    RecipeCreateGUI.openShapelessRecipeMenu(player);
                }
                RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
            });
            return;
        }
        String recipeName = session.getName();
        if (recipeName == null || recipeName.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Please set a recipe name!");
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                RecipeCreateGUI.openNameInputMenu(player);
                this.awaitingNameInput.put(playerId, true);
                session.setNameInputMode(true);
            });
            return;
        }
        HashMap<Character, Material> ingredients = new HashMap<Character, Material>();
        String[] shape = new String[3];
        if (type == RecipeCreateX.RecipeType.SHAPED) {
            StringBuilder[] shapeBuilder = new StringBuilder[3];
            boolean hasIngredients = false;
            for (int row = 0; row < 3; ++row) {
                shapeBuilder[row] = new StringBuilder();
                for (int col = 0; col < 3; ++col) {
                    int slot = 10 + col + row * 9;
                    ItemStack item = session.getIngredientItems().get(slot);
                    if (item != null && item.getType() != Material.AIR && !item.getType().name().contains("STAINED_GLASS_PANE")) {
                        char ingredientChar = (char)(65 + ingredients.size());
                        ingredients.put(Character.valueOf(ingredientChar), item.getType());
                        shapeBuilder[row].append(ingredientChar);
                        hasIngredients = true;
                        continue;
                    }
                    shapeBuilder[row].append(' ');
                }
            }
            if (!hasIngredients) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please add at least one ingredient!");
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (type == RecipeCreateX.RecipeType.SHAPED) {
                        RecipeCreateGUI.openShapedRecipeMenu(player);
                    } else {
                        RecipeCreateGUI.openShapelessRecipeMenu(player);
                    }
                    RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                });
                return;
            }
            for (int i = 0; i < 3; ++i) {
                shape[i] = shapeBuilder[i].toString();
            }
        } else if (type == RecipeCreateX.RecipeType.SHAPELESS) {
            boolean hasIngredients = false;
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int slot = 10 + col + row * 9;
                    ItemStack item = session.getIngredientItems().get(slot);
                    if (item == null || item.getType() == Material.AIR || item.getType().name().contains("STAINED_GLASS_PANE")) continue;
                    char ingredientChar = (char)(65 + ingredients.size());
                    ingredients.put(Character.valueOf(ingredientChar), item.getType());
                    hasIngredients = true;
                }
            }
            if (!hasIngredients) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please add at least one ingredient!");
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (type == RecipeCreateX.RecipeType.SHAPED) {
                        RecipeCreateGUI.openShapedRecipeMenu(player);
                    } else {
                        RecipeCreateGUI.openShapelessRecipeMenu(player);
                    }
                    RecipeCreateGUI.updateMaxCraftsButton(player, session.getMaxCrafts());
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.highlightCurrentSlot(player), 2L);
                });
                return;
            }
        }
        int maxCrafts = session.getMaxCrafts();
        this.plugin.saveRecipe(recipeName, type, resultItem, ingredients, shape, maxCrafts);
        try {
            if (type == RecipeCreateX.RecipeType.SHAPED) {
                this.plugin.registerShapedRecipe(recipeName, resultItem, ingredients, shape);
            } else {
                this.plugin.registerShapelessRecipe(recipeName, resultItem, ingredients);
            }
            Object maxCraftsInfo = maxCrafts == -1 ? "unlimited uses" : maxCrafts + " total uses";
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Recipe registered and saved successfully: " + recipeName + " (" + (String)maxCraftsInfo + ")");
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Error registering recipe: " + e.getMessage());
            this.plugin.getLogger().warning("Error registering recipe " + recipeName + ": " + e.getMessage());
            e.printStackTrace();
        }
        this.plugin.getRecipeSessions().remove(playerId);
        player.closeInventory();
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> RecipeCreateGUI.openMainMenu(player), 1L);
    }

    private boolean isInCraftingGrid(int slot) {
        int row = slot / 9;
        int col = slot % 9;
        return row >= 1 && row <= 3 && col >= 1 && col <= 3;
    }

    private boolean isResultSlot(int slot) {
        return slot == 24;
    }
}

