/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Arrays;
import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.micaxs.smokeleaf.recipe.DryingRecipe;
import net.micaxs.smokeleaf.recipe.DryingRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DryingRackBlockEntity
extends BlockEntity {
    public static final int SLOT_COUNT = 12;
    private final ItemStack[] items = new ItemStack[12];
    private final int[] progress = new int[12];
    private static final DustParticleOptions DRYING_PARTICLE = new DustParticleOptions(new Vector3f(0.4f, 0.4f, 0.4f), 0.5f);
    private static final float[] LAYER_Y = new float[]{0.1875f, 0.5625f, 0.9375f};
    private static final float[][] QUAD_OFFSETS = new float[][]{{-0.25f, 0.25f}, {0.25f, 0.25f}, {-0.25f, -0.25f}, {0.25f, -0.25f}};

    public DryingRackBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.DRYING_RACK_BE.get(), pos, state);
        Arrays.fill(this.items, ItemStack.EMPTY);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DryingRackBlockEntity be) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        boolean changed = false;
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        for (int i = 0; i < 12; ++i) {
            float[] off;
            Item item;
            ItemStack stack = be.items[i];
            if (stack.isEmpty()) {
                if (be.progress[i] == 0) continue;
                be.progress[i] = 0;
                changed = true;
                continue;
            }
            Optional recipeHolderOpt = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.DRYING_TYPE.get(), (RecipeInput)new DryingRecipeInput(stack), level);
            if (recipeHolderOpt.isEmpty()) {
                be.progress[i] = 0;
                continue;
            }
            DryingRecipe recipe = (DryingRecipe)((RecipeHolder)recipeHolderOpt.get()).value();
            if (recipe.dryBud() && (item = stack.getItem()) instanceof BaseBudItem) {
                BaseBudItem budItem = (BaseBudItem)item;
                if (be.isDry(stack)) continue;
                if (server.random.nextFloat() < 0.1f) {
                    off = be.getSlotRenderPosition(i, facing);
                    server.sendParticles((ParticleOptions)DRYING_PARTICLE, (double)pos.getX() + 0.5 + (double)off[0], (double)pos.getY() + 0.1 + (double)off[1], (double)pos.getZ() + 0.5 + (double)off[2], 1, 0.0, 0.0, 0.0, 0.0);
                }
                int n = i;
                be.progress[n] = be.progress[n] + 1;
                int needed = Math.max(1, budItem.dryingTime);
                if (be.progress[i] < needed) continue;
                BaseBudItem.changeDryStatus(stack, true);
                be.progress[i] = 0;
                changed = true;
                continue;
            }
            if (server.random.nextFloat() < 0.1f) {
                off = be.getSlotRenderPosition(i, facing);
                server.sendParticles((ParticleOptions)DRYING_PARTICLE, (double)pos.getX() + 0.5 + (double)off[0], (double)pos.getY() + 0.1 + (double)off[1], (double)pos.getZ() + 0.5 + (double)off[2], 1, 0.0, 0.0, 0.0, 0.0);
            }
            int n = i;
            be.progress[n] = be.progress[n] + 1;
            int needed = Math.max(1, recipe.time());
            if (be.progress[i] < needed) continue;
            if (!recipe.result().isEmpty()) {
                be.items[i] = recipe.result().copy();
            }
            be.progress[i] = 0;
            changed = true;
        }
        if (changed) {
            be.setChangedAndSync();
        }
    }

    public int getProgressForSlot(int slot) {
        if (slot < 0 || slot >= 12) {
            return 0;
        }
        return this.progress[slot];
    }

    public int getTotalTimeForSlot(Level level, int slot) {
        Item item;
        if (slot < 0 || slot >= 12) {
            return 0;
        }
        ItemStack stack = this.items[slot];
        if (stack.isEmpty()) {
            return 0;
        }
        Optional recipeHolderOpt = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.DRYING_TYPE.get(), (RecipeInput)new DryingRecipeInput(stack), level);
        if (recipeHolderOpt.isEmpty()) {
            return 0;
        }
        DryingRecipe recipe = (DryingRecipe)((RecipeHolder)recipeHolderOpt.get()).value();
        if (recipe.dryBud() && (item = stack.getItem()) instanceof BaseBudItem) {
            BaseBudItem budItem = (BaseBudItem)item;
            return Math.max(1, budItem.dryingTime);
        }
        return Math.max(1, recipe.time());
    }

    private boolean isDry(ItemStack stack) {
        Boolean v = (Boolean)stack.get(ModDataComponentTypes.DRY);
        return v != null && v != false;
    }

    public int firstFreeSlotBottomUp() {
        for (int i = 0; i < 12; ++i) {
            if (!this.items[i].isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public boolean insertOne(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        int slot = this.firstFreeSlotBottomUp();
        if (slot < 0) {
            return false;
        }
        this.items[slot] = stack.split(1);
        this.progress[slot] = 0;
        this.setChangedAndSync();
        return true;
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= 12) {
            return ItemStack.EMPTY;
        }
        return this.items[slot];
    }

    public float[] getSlotRenderPosition(int slot, Direction facing) {
        int layer = slot / 4;
        int quad = slot % 4;
        float y = LAYER_Y[layer];
        float ox = QUAD_OFFSETS[quad][0];
        float oz = QUAD_OFFSETS[quad][1];
        float rx = ox;
        float rz = oz;
        switch (facing) {
            case SOUTH: {
                rx = -ox;
                rz = -oz;
                break;
            }
            case WEST: {
                rx = oz;
                rz = -ox;
                break;
            }
            case EAST: {
                rx = -oz;
                rz = ox;
                break;
            }
        }
        return new float[]{rx, y, rz};
    }

    public int computeLayerFromHit(BlockHitResult hit) {
        if (hit == null) {
            return -1;
        }
        double localY = hit.getLocation().y - (double)this.worldPosition.getY();
        if (localY < 0.0 || localY > 1.0001) {
            return -1;
        }
        if (localY < 0.375) {
            return 0;
        }
        if (localY < 0.75) {
            return 1;
        }
        return 2;
    }

    public ItemStack removeLastInRow(int layer) {
        if (layer < 0 || layer > 2) {
            return ItemStack.EMPTY;
        }
        int start = layer * 4;
        for (int i = start + 3; i >= start; --i) {
            if (this.items[i].isEmpty()) continue;
            ItemStack ret = this.items[i];
            this.items[i] = ItemStack.EMPTY;
            this.progress[i] = 0;
            this.setChangedAndSync();
            return ret;
        }
        return ItemStack.EMPTY;
    }

    private void setChangedAndSync() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        for (int i = 0; i < 12; ++i) {
            CompoundTag slotTag = new CompoundTag();
            if (!this.items[i].isEmpty()) {
                slotTag.put("stack", this.items[i].save(registries));
            }
            slotTag.putInt("prog", this.progress[i]);
            tag.put("S" + i, (Tag)slotTag);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        for (int i = 0; i < 12; ++i) {
            CompoundTag slotTag = tag.getCompound("S" + i);
            this.items[i] = slotTag.contains("stack") ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)slotTag.getCompound("stack")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
            this.progress[i] = slotTag.getInt("prog");
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

