/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.micaxs.smokeleaf.block.entity.DryingRackBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DryingRackRenderer
implements BlockEntityRenderer<DryingRackBlockEntity> {
    private static final float Y_OFFSET_ADJUST = 0.05f;

    public DryingRackRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(DryingRackBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffers, int light, int overlay) {
        if (be.getLevel() == null) {
            return;
        }
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        for (int slot = 0; slot < 12; ++slot) {
            ItemStack stack = be.getItem(slot);
            if (stack.isEmpty()) continue;
            float[] off = be.getSlotRenderPosition(slot, facing);
            pose.pushPose();
            pose.translate(0.5 + (double)off[0], (double)(off[1] - 0.05f), 0.5 + (double)off[2]);
            pose.mulPose(Axis.XP.rotationDegrees(90.0f));
            pose.scale(0.4f, 0.4f, 0.4f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, pose, buffers, be.getLevel(), 0);
            pose.popPose();
        }
    }
}

