/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.client.paranoia;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

@EventBusSubscriber(modid="smokeleafindustries", value={Dist.CLIENT})
public final class HallucinationManager {
    private static final Map<Entity, Integer> LIFETIMES = new WeakHashMap<Entity, Integer>();
    private static final AtomicInteger NEXT_FAKE_ID = new AtomicInteger(-1);
    private static final float GHOST_ALPHA = 0.3f;

    private HallucinationManager() {
    }

    public static void spawn(EntityType<?> type, double x, double y, double z, float yaw, int lifeTicks, SoundEvent soundOrNull) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        Entity e = type.create((Level)level);
        if (e == null) {
            return;
        }
        double groundY = HallucinationManager.findGroundY(level, x, y, z);
        e.moveTo(x, groundY, z, yaw, 0.0f);
        e.setNoGravity(true);
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            mob.setNoAi(true);
        }
        int id = NEXT_FAKE_ID.getAndDecrement();
        e.setId(id);
        level.addEntity(e);
        LIFETIMES.put(e, Math.max(1, lifeTicks));
        if (soundOrNull != null) {
            level.playLocalSound(x, groundY, z, soundOrNull, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    public static boolean isHallucination(Entity e) {
        return e != null && LIFETIMES.containsKey(e);
    }

    @SubscribeEvent
    public static void onRenderLivingPre(RenderLivingEvent.Pre<?, ?> evt) {
        if (!HallucinationManager.isHallucination((Entity)evt.getEntity())) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
    }

    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post<?, ?> evt) {
        if (!HallucinationManager.isHallucination((Entity)evt.getEntity())) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post evt) {
        if (LIFETIMES.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Entity, Integer>> it = LIFETIMES.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Entity, Integer> entry = it.next();
            Entity e = entry.getKey();
            if (e == null || e.level() == null || !e.level().isClientSide()) {
                it.remove();
                continue;
            }
            int left = entry.getValue() - 1;
            if (left <= 0) {
                e.remove(Entity.RemovalReason.DISCARDED);
                Level level = e.level();
                if (level instanceof ClientLevel) {
                    ClientLevel cl = (ClientLevel)level;
                    cl.removeEntity(e.getId(), Entity.RemovalReason.DISCARDED);
                }
                it.remove();
                continue;
            }
            entry.setValue(left);
        }
    }

    private static double findGroundY(ClientLevel level, double x, double startY, double z) {
        double toY;
        Vec3 to;
        double fromY = Math.min((double)(level.getMaxBuildHeight() - 1), startY + 32.0);
        Vec3 from = new Vec3(x, fromY, z);
        BlockHitResult hit = level.clip(new ClipContext(from, to = new Vec3(x, toY = Math.max((double)level.getMinBuildHeight(), startY - 64.0), z), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, CollisionContext.empty()));
        if (hit.getType() != HitResult.Type.MISS) {
            return hit.getLocation().y + 0.01;
        }
        return startY;
    }
}

