/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.micaxs.smokeleaf.effect.ModEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="smokeleafindustries", value={Dist.CLIENT})
public final class RedEyesOverlay {
    private RedEyesOverlay() {
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        MobEffectInstance inst = mc.player.getEffect(ModEffects.DRY_EYES);
        if (inst == null) {
            return;
        }
        int w = mc.getWindow().getGuiScaledWidth();
        int h = mc.getWindow().getGuiScaledHeight();
        float alpha = Mth.clamp((float)(0.28f + 0.14f * (float)(inst.getAmplifier() + 1)), (float)0.0f, (float)0.85f);
        int a = (int)(alpha * 255.0f) << 24;
        int colorARGB = a | 0xA83232;
        GuiGraphics g = event.getGuiGraphics();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        g.pose().pushPose();
        g.pose().translate(0.0f, 0.0f, 1000.0f);
        g.fill(0, 0, w, h, colorARGB);
        g.pose().popPose();
        RenderSystem.disableBlend();
    }
}

