/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jade;

import net.micaxs.smokeleaf.block.entity.DryingRackBlockEntity;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum DryingRackProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof DryingRackBlockEntity)) {
            return;
        }
        DryingRackBlockEntity rack = (DryingRackBlockEntity)blockEntity;
        for (int i = 0; i < 12; ++i) {
            ItemStack stack = rack.getItem(i);
            if (stack.isEmpty()) continue;
            boolean isBud = stack.getItem() instanceof BaseBudItem;
            boolean isDryBud = false;
            if (isBud) {
                Boolean dry = (Boolean)stack.get(ModDataComponentTypes.DRY);
                isDryBud = dry != null && dry != false;
            }
            int needed = rack.getTotalTimeForSlot(accessor.getLevel(), i);
            int prog = rack.getProgressForSlot(i);
            int remainTicks = 0;
            boolean active = false;
            if (isBud && isDryBud) {
                active = false;
                remainTicks = 0;
            } else if (needed > 0) {
                remainTicks = Math.max(0, needed - prog);
                active = remainTicks > 0;
            } else {
                active = false;
                remainTicks = 0;
            }
            int remainSeconds = (int)Math.ceil((double)remainTicks / 20.0);
            CompoundTag slot = new CompoundTag();
            slot.putString("id", BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
            slot.putBoolean("bud", isBud);
            slot.putBoolean("dry", isDryBud);
            slot.putBoolean("active", active);
            slot.putInt("sec", remainSeconds);
            tag.put("S" + i, (Tag)slot);
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        IElementHelper elements = IElementHelper.get();
        for (int i = 0; i < 12; ++i) {
            MutableComponent line;
            CompoundTag s;
            ResourceLocation id;
            String key = "S" + i;
            if (!accessor.getServerData().contains(key) || (id = ResourceLocation.tryParse((String)(s = accessor.getServerData().getCompound(key)).getString("id"))) == null) continue;
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            IElement icon = elements.item(new ItemStack((ItemLike)item), 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(-2.0f, -1.0f));
            boolean isBud = s.getBoolean("bud");
            boolean isDryBud = s.getBoolean("dry");
            boolean active = s.getBoolean("active");
            int seconds = s.getInt("sec");
            MutableComponent name = Component.translatable((String)item.getDescriptionId()).withStyle(ChatFormatting.WHITE);
            if (isBud && isDryBud) {
                line = Component.empty().append((Component)name).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)"Dry").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.DARK_GRAY));
            } else if (active) {
                String mmss = DryingRackProvider.formatMMSS(seconds);
                line = Component.empty().append((Component)name).append((Component)Component.literal((String)" (").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)("Time Left: " + mmss)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.DARK_GRAY));
            } else {
                line = name;
            }
            tooltip.add(icon);
            tooltip.append((IElement)elements.text((Component)line));
        }
    }

    private static String formatMMSS(int totalSeconds) {
        int m = Math.max(0, totalSeconds) / 60;
        int s = Math.max(0, totalSeconds) % 60;
        return m + ":" + (String)(s < 10 ? "0" + s : String.valueOf(s));
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"drying_rack");
    }
}

