/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jade;

import net.micaxs.smokeleaf.Config;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.entity.BaseWeedCropBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum WeedCropProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntity be;
        BlockState state = accessor.getBlockState();
        BlockPos pos = accessor.getPosition();
        if (state.hasProperty((Property)BaseWeedCropBlock.TOP) && ((Boolean)state.getValue((Property)BaseWeedCropBlock.TOP)).booleanValue()) {
            pos = pos.below();
        }
        if ((be = accessor.getLevel().getBlockEntity(pos)) instanceof BaseWeedCropBlockEntity) {
            BaseWeedCropBlockEntity crop = (BaseWeedCropBlockEntity)be;
            tag.putInt("n", crop.getNitrogen());
            tag.putInt("p", crop.getPhosphorus());
            tag.putInt("k", crop.getPotassium());
            Config.NutrientTarget target = crop.getOptimalNutrientsLevels();
            tag.putInt("tn", target.n);
            tag.putInt("tp", target.p);
            tag.putInt("tk", target.k);
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (!WeedCropProvider.hasAll(data, "n", "p", "k", "tn", "tp", "tk")) {
            return;
        }
        int n = data.getInt("n");
        int p = data.getInt("p");
        int k = data.getInt("k");
        int tn = data.getInt("tn");
        int tp = data.getInt("tp");
        int tk = data.getInt("tk");
        if (tn == 0 && tp == 0 && tk == 0) {
            return;
        }
        tooltip.add((Component)Component.literal((String)"Nitrogen (N): ").append((Component)Component.literal((String)String.valueOf(n)).withStyle(WeedCropProvider.colorForDiff(Math.abs(n - tn)))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(tn)).withStyle(ChatFormatting.GREEN)));
        tooltip.add((Component)Component.literal((String)"Phosphorus (P): ").append((Component)Component.literal((String)String.valueOf(p)).withStyle(WeedCropProvider.colorForDiff(Math.abs(p - tp)))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(tp)).withStyle(ChatFormatting.GREEN)));
        tooltip.add((Component)Component.literal((String)"Potassium (K): ").append((Component)Component.literal((String)String.valueOf(k)).withStyle(WeedCropProvider.colorForDiff(Math.abs(k - tk)))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(tk)).withStyle(ChatFormatting.GREEN)));
    }

    private static boolean hasAll(CompoundTag t, String ... keys) {
        for (String k : keys) {
            if (t.contains(k)) continue;
            return false;
        }
        return true;
    }

    private static ChatFormatting colorForDiff(int diff) {
        if (diff == 0) {
            return ChatFormatting.GREEN;
        }
        if (diff == 1) {
            return ChatFormatting.GOLD;
        }
        if (diff == 2) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.DARK_RED;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"weed_crop_jade");
    }
}

