/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.component.DNAContents;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.recipe.SequencerRecipe;
import net.micaxs.smokeleaf.recipe.SynthesizerRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SynthesizerRecipeCategory
implements IRecipeCategory<Display> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"synthesizer");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/synthesizer/synthesizer_gui.png");
    public static final RecipeType<Display> SYNTHESIZER_RECIPE_TYPE = new RecipeType(UID, Display.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public SynthesizerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 5, 5, 168, 75);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SYNTHESIZER.get()));
        IDrawableStatic arrowStatic = helper.createDrawable(TEXTURE, 176, 0, 8, 26);
        this.arrow = helper.createAnimatedDrawable(arrowStatic, 120, IDrawableAnimated.StartDirection.TOP, false);
    }

    public RecipeType<Display> getRecipeType() {
        return SYNTHESIZER_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.smokeleafindustries.synthesizer");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(Display display, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 125, 25);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Display display, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 75, 6).addItemStack(display.dnaInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 30).addItemStack(display.reagent1());
        builder.addSlot(RecipeIngredientRole.INPUT, 75, 30).addItemStack(display.reagent2());
        builder.addSlot(RecipeIngredientRole.INPUT, 93, 30).addItemStack(display.reagent3());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 75, 54).addItemStack(display.outputDNA());
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 75;
    }

    public static List<Display> buildValidStrainDisplays(SynthesizerRecipe base, List<SequencerRecipe> sequencerRecipes) {
        ItemStack emptyDNA = new ItemStack((ItemLike)ModItems.DNA_STRAND.get());
        HashSet seenKeys = new HashSet();
        return sequencerRecipes.stream().map(seq -> {
            Ingredient[] ing = seq.requiredReagents();
            if (ing.length != 3) {
                return null;
            }
            ItemStack a = SynthesizerRecipeCategory.firstNonEmpty(ing[0]);
            ItemStack b = SynthesizerRecipeCategory.firstNonEmpty(ing[1]);
            ItemStack c = SynthesizerRecipeCategory.firstNonEmpty(ing[2]);
            if (a.isEmpty() || b.isEmpty() || c.isEmpty()) {
                return null;
            }
            String key = SynthesizerRecipeCategory.canonicalKey(a, b, c);
            if (!seenKeys.add(key)) {
                return null;
            }
            ItemStack output = new ItemStack((ItemLike)ModItems.DNA_STRAND.get());
            output.set((DataComponentType)ModDataComponentTypes.DNA_CONTENTS.get(), (Object)new DNAContents(a.copyWithCount(1), b.copyWithCount(1), c.copyWithCount(1)));
            return new Display(base, emptyDNA.copy(), a.copy(), b.copy(), c.copy(), output);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static ItemStack firstNonEmpty(Ingredient ingredient) {
        for (ItemStack s : ingredient.getItems()) {
            if (s.isEmpty()) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private static String canonicalKey(ItemStack a, ItemStack b, ItemStack c) {
        ArrayList<String> ids = new ArrayList<String>(3);
        ids.add(BuiltInRegistries.ITEM.getKey((Object)a.getItem()).toString());
        ids.add(BuiltInRegistries.ITEM.getKey((Object)b.getItem()).toString());
        ids.add(BuiltInRegistries.ITEM.getKey((Object)c.getItem()).toString());
        Collections.sort(ids);
        return String.join((CharSequence)"|", ids);
    }

    public record Display(SynthesizerRecipe base, ItemStack dnaInput, ItemStack reagent1, ItemStack reagent2, ItemStack reagent3, ItemStack outputDNA) {
    }
}

