/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.effect.beneficial;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SleepyEffect
extends MobEffect {
    private static final double MIN_LEFT = 0.5;
    private static final double MAX_LEFT = 1.0;
    private static final double MIN_RIGHT = 0.5;
    private static final double MAX_RIGHT = 1.5;
    private static final double FREQUENCY_HZ = 1.1;
    private static final double POS_GAIN = 0.18;
    private static final double SMOOTHING = 0.35;
    private static final double MAX_LAT_VEL = 0.24;
    private static final double AMP_PER_LEVEL = 0.12;
    private static final String KEY_BASE = "smokeleaf.sleepy.";
    private static final String KEY_AX = "smokeleaf.sleepy.ax";
    private static final String KEY_AZ = "smokeleaf.sleepy.az";
    private static final String KEY_LS = "smokeleaf.sleepy.lastSign";
    private static final String KEY_AMP = "smokeleaf.sleepy.amp";

    public SleepyEffect(MobEffectCategory category, int color) {
        super(category, color);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.parse((String)UUID.randomUUID().toString()), -0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = player.getPersistentData();
            if (player.zza > 0.0f) {
                double amp;
                double yawRad = Math.toRadians(player.getYRot());
                double fwdX = -Math.sin(yawRad);
                double fwdZ = Math.cos(yawRad);
                double rightX = Math.cos(yawRad);
                double rightZ = Math.sin(yawRad);
                double dt = 0.05;
                Vec3 v = player.getDeltaMovement();
                double forwardSpeed = v.x * fwdX + v.z * fwdZ;
                double anchorX = tag.contains(KEY_AX) ? tag.getDouble(KEY_AX) : player.getX();
                double anchorZ = tag.contains(KEY_AZ) ? tag.getDouble(KEY_AZ) : player.getZ();
                tag.putDouble(KEY_AX, anchorX += fwdX * forwardSpeed * dt);
                tag.putDouble(KEY_AZ, anchorZ += fwdZ * forwardSpeed * dt);
                double lateralOffset = (player.getX() - anchorX) * rightX + (player.getZ() - anchorZ) * rightZ;
                double omega = 0.3455751918948773;
                double phase = (double)(player.getId() & 0xFF) / 255.0 * (Math.PI * 2);
                double s = Math.sin(omega * (double)player.tickCount + phase);
                int sign = s >= 0.0 ? 1 : -1;
                int lastSign = tag.contains(KEY_LS) ? tag.getInt(KEY_LS) : sign;
                double ampScale = 1.0 + 0.12 * (double)Math.max(0, amplifier);
                double d = tag.contains(KEY_AMP) ? tag.getDouble(KEY_AMP) : (amp = SleepyEffect.pickAmplitude(player, sign >= 0, ampScale));
                if (sign != lastSign) {
                    amp = SleepyEffect.pickAmplitude(player, sign >= 0, ampScale);
                    tag.putInt(KEY_LS, sign);
                    tag.putDouble(KEY_AMP, amp);
                }
                double desiredOffset = s * amp;
                double error = desiredOffset - lateralOffset;
                double desiredLatVel = SleepyEffect.clamp(error * 0.18, -0.24, 0.24);
                if (player.isShiftKeyDown()) {
                    desiredLatVel *= 0.5;
                }
                double currentLatVel = v.x * rightX + v.z * rightZ;
                double delta = (desiredLatVel - currentLatVel) * 0.35;
                player.setDeltaMovement(v.add(rightX * delta, 0.0, rightZ * delta));
            } else {
                tag.putDouble(KEY_AX, entity.getX());
                tag.putDouble(KEY_AZ, entity.getZ());
                tag.putInt(KEY_LS, 0);
            }
        }
        return true;
    }

    private static double pickAmplitude(Player p, boolean rightSide, double scale) {
        double min = rightSide ? 0.5 : 0.5;
        double max = rightSide ? 1.5 : 1.0;
        double a = min + p.getRandom().nextDouble() * (max - min);
        return a * scale;
    }

    private static double clamp(double v, double lo, double hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

