/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.effect.neutral;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ZombifiedEffect
extends MobEffect {
    public ZombifiedEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (level.isClientSide) {
            return false;
        }
        if (entity instanceof Player) {
            boolean inSunlight;
            Player player = (Player)entity;
            if (player.isCreative() || player.isSpectator()) {
                return false;
            }
            BlockPos pos = BlockPos.containing((double)player.getX(), (double)player.getEyeY(), (double)player.getZ());
            boolean bl = inSunlight = level.isDay() && level.canSeeSky(pos) && !player.isInWaterRainOrBubble();
            if (inSunlight) {
                ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
                if (helmet.isEmpty()) {
                    int fireTicks = 160;
                    if (player.getRemainingFireTicks() < fireTicks) {
                        player.setRemainingFireTicks(fireTicks);
                    }
                } else {
                    helmet.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
                }
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

