/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.fluid;

import java.util.function.Supplier;
import net.micaxs.smokeleaf.fluid.BaseFluidType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.SoundAction;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.joml.Vector3f;

public class ModFluidTypes {
    public static final ResourceLocation WATER_STILL_RL = ResourceLocation.parse((String)"block/water_still");
    public static final ResourceLocation WATER_FLOWING_RL = ResourceLocation.parse((String)"block/water_flow");
    public static final ResourceLocation WATER_OVERLAY_RL = ResourceLocation.parse((String)"block/water_overlay");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"smokeleafindustries");
    public static final Supplier<FluidType> HASH_OIL_FLUID_TYPE = ModFluidTypes.registerFluidType("hash_oil_fluid", new BaseFluidType(WATER_STILL_RL, WATER_FLOWING_RL, WATER_OVERLAY_RL, -1577938130, new Vector3f(0.9490196f, 0.5764706f, 0.18039216f), FluidType.Properties.create().canExtinguish(true).lightLevel(3).density(15).viscosity(5).sound(SoundAction.get((String)"drink"), SoundEvents.HONEY_DRINK)));
    public static final Supplier<FluidType> HASH_OIL_SLUDGE_FLUID_TYPE = ModFluidTypes.registerFluidType("hash_oil_sludge_fluid", new BaseFluidType(WATER_STILL_RL, WATER_FLOWING_RL, WATER_OVERLAY_RL, -12895429, new Vector3f(0.23137255f, 0.23137255f, 0.23137255f), FluidType.Properties.create().canExtinguish(true).lightLevel(3).density(15).viscosity(5).sound(SoundAction.get((String)"drink"), SoundEvents.HONEY_DRINK)));
    public static final Supplier<FluidType> HEMP_OIL_FLUID_TYPE = ModFluidTypes.registerFluidType("hemp_oil_fluid", new BaseFluidType(WATER_STILL_RL, WATER_FLOWING_RL, WATER_OVERLAY_RL, -10949836, new Vector3f(0.23137255f, 0.23137255f, 0.23137255f), FluidType.Properties.create().canExtinguish(true).lightLevel(3).density(15).viscosity(5).sound(SoundAction.get((String)"drink"), SoundEvents.HONEY_DRINK)));

    private static Supplier<FluidType> registerFluidType(String name, FluidType fluidType) {
        return FLUID_TYPES.register(name, () -> fluidType);
    }

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }
}

