/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BaseLampItem
extends Item {
    private static final int TICKS_PER_SECOND = 20;

    public BaseLampItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int remainingTicks = stack.getMaxDamage() - stack.getDamageValue();
        if (remainingTicks < 0) {
            remainingTicks = 0;
        }
        long totalSeconds = (remainingTicks + 19) / 20;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        tooltipComponents.add((Component)Component.literal((String)String.format("Lifespan: %02d:%02d", minutes, seconds)).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.hps_lamp").withStyle(ChatFormatting.DARK_GRAY));
    }
}

