/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.utils.WeedEffectHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BaseWeedItem
extends Item {
    private static final List<ResourceLocation> ADDITIONAL_EFFECT_POOL = new ArrayList<ResourceLocation>();
    private final MobEffect effect;
    private final int duration;
    private int effectAmplifier;
    private final int thcLevel;
    private final int cbdLevel;
    private boolean variableDuration;
    private final String[] weedNameParts = new String[2];
    private float durationMultiplier = 1.0f;

    public static void setAdditionalEffectPool(Collection<ResourceLocation> effectIds) {
        ADDITIONAL_EFFECT_POOL.clear();
        for (ResourceLocation rl : effectIds) {
            if (rl == null || !BuiltInRegistries.MOB_EFFECT.containsKey(rl)) continue;
            ADDITIONAL_EFFECT_POOL.add(rl);
        }
    }

    public static void addToAdditionalEffectPool(ResourceLocation effectId) {
        if (effectId != null && BuiltInRegistries.MOB_EFFECT.containsKey(effectId)) {
            ADDITIONAL_EFFECT_POOL.add(effectId);
        }
    }

    public BaseWeedItem(Item.Properties pProperties, MobEffect effect, int iDuration, int iAmplifier, int iThc, int iCbd, String weedNamePart1, String weedNamePart2) {
        this(pProperties, effect, iDuration, iAmplifier, iThc, iCbd, true);
        this.weedNameParts[0] = weedNamePart1;
        this.weedNameParts[1] = weedNamePart2;
    }

    public BaseWeedItem(Item.Properties pProperties, MobEffect effect, int iDuration, int iAmplifier, int iThc, int iCbd, boolean variableDuration) {
        super(pProperties);
        this.duration = iDuration;
        this.thcLevel = iThc;
        this.cbdLevel = iCbd;
        this.effect = effect;
        this.effectAmplifier = iAmplifier;
        this.variableDuration = variableDuration;
    }

    public void initializeStack(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get(), (Object)BuiltInRegistries.MOB_EFFECT.getKey((Object)this.effect).toString());
        stack.set((DataComponentType)ModDataComponentTypes.EFFECT_DURATION.get(), (Object)this.duration);
        stack.set((DataComponentType)ModDataComponentTypes.THC.get(), (Object)this.thcLevel);
        stack.set((DataComponentType)ModDataComponentTypes.CBD.get(), (Object)this.cbdLevel);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        List<MobEffectInstance> previews = this.buildEffectInstances(stack);
        if (previews.isEmpty()) {
            return;
        }
        MobEffectInstance first = previews.get(0);
        MobEffect eff = (MobEffect)first.getEffect().value();
        int dur = first.getDuration();
        tooltipComponents.add(WeedEffectHelper.getEffectTooltip(eff, dur, true));
        tooltipComponents.add((Component)Component.empty());
        tooltipComponents.add(this.getLevelsText(stack));
        if (previews.size() > 1) {
            MutableComponent joined = Component.empty();
            for (int i = 1; i < previews.size(); ++i) {
                MobEffect extra = (MobEffect)previews.get(i).getEffect().value();
                MutableComponent name = Component.translatable((String)extra.getDescriptionId()).withStyle(ChatFormatting.WHITE);
                if (i > 1) {
                    joined = joined.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GRAY));
                }
                joined = joined.append((Component)name);
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.extra_effects", (Object[])new Object[]{joined}).withStyle(ChatFormatting.GRAY));
        }
        if (this.variableDuration) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.base_weed").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    private Component getLevelsText(ItemStack stack) {
        int thc = this.getTHC(stack);
        int cbd = this.getCBD(stack);
        return Component.literal((String)"Levels: ").append((Component)Component.literal((String)(thc + "%")).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" THC").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)" & ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(cbd + "%")).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" CBD").withStyle(ChatFormatting.DARK_GRAY));
    }

    public int getDuration(ItemStack stack) {
        return this.computeUnifiedDurationTicks(stack);
    }

    public MobEffect getEffect(ItemStack stack) {
        MobEffect effect;
        ResourceLocation effectRL;
        String effectId = (String)stack.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get());
        if (effectId == null) {
            effectId = BuiltInRegistries.MOB_EFFECT.getKey((Object)this.effect).toString();
        }
        if ((effectRL = ResourceLocation.tryParse((String)effectId)) != null && (effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(effectRL)) != null) {
            return effect;
        }
        return null;
    }

    public int getTHC(ItemStack stack) {
        Integer thc = (Integer)stack.get((DataComponentType)ModDataComponentTypes.THC.get());
        return thc != null ? thc : this.thcLevel;
    }

    public int getCBD(ItemStack stack) {
        Integer cbd = (Integer)stack.get((DataComponentType)ModDataComponentTypes.CBD.get());
        return cbd != null ? cbd : this.cbdLevel;
    }

    private int computeUnifiedDurationTicks(ItemStack stack) {
        int cbd = this.getCBD(stack);
        int seconds = cbd > 30 ? 60 : (cbd > 15 ? 20 : 10);
        return (int)((float)(seconds * 20) * this.durationMultiplier);
    }

    private int computeExtraEffectCount(int thc) {
        if (thc > 35) {
            return 2;
        }
        if (thc > 20 && thc < 35) {
            return 1;
        }
        return 0;
    }

    private List<MobEffect> getDeterministicExtraEffects(ItemStack stack, int count) {
        if (count <= 0 || ADDITIONAL_EFFECT_POOL.isEmpty()) {
            return List.of();
        }
        MobEffect base = this.getEffect(stack);
        ResourceLocation baseId = base != null ? BuiltInRegistries.MOB_EFFECT.getKey((Object)base) : null;
        int thc = this.getTHC(stack);
        int cbd = this.getCBD(stack);
        long seed = 1469598103934665603L;
        seed ^= (long)(baseId != null ? baseId.toString().hashCode() : 0);
        seed = seed * 1099511628211L ^ (long)thc;
        seed = seed * 1099511628211L ^ (long)cbd;
        String activeStr = (String)stack.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get());
        if (activeStr != null) {
            seed = seed * 1099511628211L ^ (long)activeStr.hashCode();
        }
        ArrayList<MobEffect> candidates = new ArrayList<MobEffect>();
        for (ResourceLocation rl : ADDITIONAL_EFFECT_POOL) {
            MobEffect eff;
            if (rl == null || baseId != null && rl.equals((Object)baseId) || (eff = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(rl)) == null) continue;
            candidates.add(eff);
        }
        if (candidates.isEmpty()) {
            return List.of();
        }
        Collections.shuffle(candidates, new Random(seed));
        if (count >= candidates.size()) {
            return List.copyOf(candidates);
        }
        return List.copyOf(candidates.subList(0, count));
    }

    private static Holder<MobEffect> toHolder(MobEffect effect) {
        if (effect == null) {
            return null;
        }
        Registry registry = BuiltInRegistries.MOB_EFFECT;
        Optional keyOpt = registry.getResourceKey((Object)effect);
        if (keyOpt.isPresent()) {
            return registry.getHolderOrThrow((ResourceKey)keyOpt.get());
        }
        return Holder.direct((Object)effect);
    }

    public List<MobEffectInstance> buildEffectInstances(ItemStack stack) {
        int durationTicks = this.computeUnifiedDurationTicks(stack);
        int amp = this.effectAmplifier;
        ArrayList<MobEffectInstance> out = new ArrayList<MobEffectInstance>();
        MobEffect base = this.getEffect(stack);
        Holder<MobEffect> baseHolder = BaseWeedItem.toHolder(base);
        if (baseHolder != null) {
            out.add(new MobEffectInstance(baseHolder, durationTicks, amp, false, true, true));
        }
        int extraCount = this.computeExtraEffectCount(this.getTHC(stack));
        for (MobEffect eff : this.getDeterministicExtraEffects(stack, extraCount)) {
            Holder<MobEffect> effHolder = BaseWeedItem.toHolder(eff);
            if (effHolder == null) continue;
            out.add(new MobEffectInstance(effHolder, durationTicks, amp, false, true, true));
        }
        return out;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide) {
            for (MobEffectInstance inst : this.buildEffectInstances(stack)) {
                if (inst == null || inst.getEffect() == null) continue;
                entity.addEffect(inst);
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    public int getDuration() {
        return this.duration;
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public void setEffectAmplifier(int effectAmplifier) {
        this.effectAmplifier = effectAmplifier;
    }

    public boolean isVariableDuration() {
        return this.variableDuration;
    }

    public void setVariableDuration(boolean variableDuration) {
        this.variableDuration = variableDuration;
    }

    public String[] getWeedNameParts() {
        return this.weedNameParts;
    }

    public float getDurationMultiplier() {
        return this.durationMultiplier;
    }

    public void setDurationMultiplier(float durationMultiplier) {
        this.durationMultiplier = durationMultiplier;
    }
}

