/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.ArrayList;
import java.util.List;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.sound.ModSounds;
import net.micaxs.smokeleaf.utils.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BongItem
extends Item {
    public BongItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 30;
    }

    private List<MobEffectInstance> getOffhandEffects(ItemStack offhandItem, LivingEntity entity) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        Item item = offhandItem.getItem();
        if (!(item instanceof BaseWeedItem)) {
            return effects;
        }
        BaseWeedItem weedItem = (BaseWeedItem)item;
        List<MobEffectInstance> built = weedItem.buildEffectInstances(offhandItem);
        if (built.isEmpty()) {
            return effects;
        }
        for (MobEffectInstance inst : built) {
            Holder holder = inst.getEffect();
            int duration = inst.getDuration();
            MobEffectInstance current = entity.getEffect(holder);
            int totalDuration = current != null ? current.getDuration() + duration : duration;
            effects.add(new MobEffectInstance(holder, totalDuration, inst.getAmplifier(), inst.isAmbient(), inst.isVisible(), inst.showIcon()));
        }
        return effects;
    }

    private Holder<MobEffect> toHolder(MobEffect effect, LivingEntity entity) {
        return (Holder)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)effect).flatMap(key -> entity.level().registryAccess().registryOrThrow(Registries.MOB_EFFECT).getHolder(key)).orElseThrow(() -> new IllegalStateException("Unregistered MobEffect: " + String.valueOf(effect)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (!this.isValidOffhandItem(player.getItemInHand(InteractionHand.OFF_HAND))) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        InteractionHand offHand = InteractionHand.OFF_HAND;
        ItemStack offhandItem = livingEntity.getItemInHand(offHand);
        if (this.isValidOffhandItem(offhandItem)) {
            livingEntity.setItemInHand(InteractionHand.OFF_HAND, offhandItem);
            List<MobEffectInstance> offhandEffects = this.getOffhandEffects(offhandItem, livingEntity);
            this.spawnSmokeParticles(level, livingEntity);
            offhandItem.shrink(1);
            for (MobEffectInstance effect : offhandEffects) {
                livingEntity.addEffect(effect);
            }
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    private void spawnSmokeParticles(Level level, LivingEntity entity) {
        for (int i = 0; i < 10; ++i) {
            double xOffset = level.random.nextGaussian() * 0.02;
            double yOffset = level.random.nextGaussian() * 0.02;
            double zOffset = level.random.nextGaussian() * 0.02;
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, entity.getX() + (double)entity.getBbWidth() * (level.random.nextDouble() - 0.5), entity.getEyeY(), entity.getZ() + (double)entity.getBbWidth() * (level.random.nextDouble() - 0.5), xOffset, yOffset, zOffset);
        }
    }

    private boolean isValidOffhandItem(ItemStack offhand) {
        if (!offhand.isEmpty()) {
            return offhand.is(ModTags.WEEDS);
        }
        return false;
    }

    public SoundEvent getDrinkingSound() {
        return ModSounds.BONG_HIT.get();
    }
}

