/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.List;
import java.util.Optional;
import net.micaxs.smokeleaf.component.ManualGrinderContents;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.micaxs.smokeleaf.recipe.ManualGrinderInput;
import net.micaxs.smokeleaf.recipe.ManualGrinderRecipe;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ManualGrinderItem
extends Item {
    public ManualGrinderItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack grinder = player.getItemInHand(hand);
        ItemStack stored = this.getStored(grinder);
        if (stored.isEmpty()) {
            return InteractionResultHolder.pass((Object)grinder);
        }
        if (!this.isValidIngredient(level, stored)) {
            return InteractionResultHolder.fail((Object)grinder);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)grinder);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseTicks) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stored = this.getStored(stack);
        if (stored.isEmpty()) {
            player.releaseUsingItem();
            return;
        }
        Optional<ManualGrinderRecipe> match = this.getRecipe(level, stored);
        if (match.isEmpty()) {
            player.releaseUsingItem();
            return;
        }
        int used = this.getUseDuration(stack, entity) - remainingUseTicks;
        int needed = match.get().grindTime();
        if (used % 10 == 0 && level.isClientSide) {
            level.playLocalSound(player.getX(), player.getY(), player.getZ(), ModSounds.MANUAL_GRINDER.get(), SoundSource.PLAYERS, 0.25f, 1.0f, false);
        }
        if (used >= needed) {
            if (!level.isClientSide) {
                ManualGrinderRecipe recipe = match.get();
                ItemStack result = recipe.assemble(new ManualGrinderInput(stored.copyWithCount(1)), (HolderLookup.Provider)level.registryAccess());
                boolean bonus = this.isDriedBud(stored);
                stored.shrink(1);
                if (stored.isEmpty()) {
                    stack.remove((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get());
                } else {
                    stack.set((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get(), (Object)ManualGrinderContents.fromStack(stored));
                }
                if (bonus) {
                    result.grow(1);
                }
                if (!player.addItem(result)) {
                    player.drop(result, false);
                }
                level.playSound(null, player.blockPosition(), ModSounds.MANUAL_GRINDER.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
            }
            player.releaseUsingItem();
        }
    }

    private boolean isDriedBud(ItemStack stack) {
        if (!(stack.getItem() instanceof BaseBudItem)) {
            return false;
        }
        Boolean dry = (Boolean)stack.get(ModDataComponentTypes.DRY);
        return Boolean.TRUE.equals(dry);
    }

    private Optional<ManualGrinderRecipe> getRecipe(Level level, ItemStack ingredient) {
        if (level == null || ingredient.isEmpty()) {
            return Optional.empty();
        }
        ManualGrinderInput input = new ManualGrinderInput(ingredient.copyWithCount(1));
        return level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.MANUAL_GRINDER_TYPE.get(), (RecipeInput)input, level).map(holder -> (ManualGrinderRecipe)holder.value());
    }

    private boolean isValidIngredient(Level level, ItemStack ingredient) {
        return this.getRecipe(level, ingredient).isPresent();
    }

    private ItemStack getStored(ItemStack grinder) {
        ManualGrinderContents data = (ManualGrinderContents)grinder.get((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get());
        return data == null ? ItemStack.EMPTY : data.toStack();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ItemStack stored = this.getStored(stack);
        if (stored.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.manual_grinder.empty").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.manual_grinder.usage_empty").withStyle(ChatFormatting.DARK_GRAY));
        } else {
            boolean valid;
            tooltip.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.manual_grinder.contains", (Object[])new Object[]{stored.getHoverName()}).withStyle(ChatFormatting.GREEN));
            boolean bl = valid = context.level() != null && this.isValidIngredient(context.level(), stored);
            if (!valid) {
                tooltip.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.manual_grinder.invalid").withStyle(ChatFormatting.RED));
            }
            tooltip.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.manual_grinder.usage_full").withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

