/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.recipe.GrinderRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record GrinderRecipe(Ingredient inputItem, ItemStack output) implements Recipe<GrinderRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    public boolean matches(GrinderRecipeInput grinderRecipeInput, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        return this.inputItem.test(grinderRecipeInput.getItem(0));
    }

    public ItemStack assemble(GrinderRecipeInput grinderRecipeInput, HolderLookup.Provider provider) {
        ItemStack out = this.output.copy();
        ItemStack in = grinderRecipeInput.getItem(0);
        if (!in.isEmpty()) {
            Item item = out.getItem();
            if (item instanceof BaseWeedItem) {
                BaseWeedItem weedItem = (BaseWeedItem)item;
                weedItem.initializeStack(out);
            }
            Integer thc = (Integer)in.get((DataComponentType)ModDataComponentTypes.THC.get());
            Integer cbd = (Integer)in.get((DataComponentType)ModDataComponentTypes.CBD.get());
            System.out.println("BUD thc/cbd: " + thc + "/" + cbd);
            if (thc != null) {
                out.set((DataComponentType)ModDataComponentTypes.THC.get(), (Object)thc);
            }
            if (cbd != null) {
                out.set((DataComponentType)ModDataComponentTypes.CBD.get(), (Object)cbd);
            }
        }
        return out;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.GRINDER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.GRINDER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<GrinderRecipe> {
        public static final MapCodec<GrinderRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(GrinderRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(GrinderRecipe::output)).apply((Applicative)inst, GrinderRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GrinderRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, GrinderRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, GrinderRecipe::output, GrinderRecipe::new);

        public MapCodec<GrinderRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GrinderRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

