/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.micaxs.smokeleaf.item.custom.JointItem;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.utils.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class JointRecipe
extends CustomRecipe {
    private static final TagKey<Item> JOINT_WEEDS = ModTags.WEEDS;
    private final Item tobaccoItem;
    private final Item jointResult;

    public JointRecipe(CraftingBookCategory category, Item tobaccoItem, Item jointResult) {
        super(category);
        this.tobaccoItem = tobaccoItem;
        this.jointResult = jointResult;
    }

    public Item getTobaccoItem() {
        return this.tobaccoItem;
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.hasPattern(input);
    }

    private boolean hasPattern(CraftingInput input) {
        if (input.width() < 3 || input.height() < 3) {
            return false;
        }
        ItemStack pTop = input.getItem(1);
        ItemStack left = input.getItem(3);
        ItemStack mid = input.getItem(4);
        ItemStack right = input.getItem(5);
        ItemStack pBottom = input.getItem(7);
        if (pTop.isEmpty() || pBottom.isEmpty() || left.isEmpty() || right.isEmpty() || mid.isEmpty()) {
            return false;
        }
        if (!pTop.is(Items.PAPER) || !pBottom.is(Items.PAPER)) {
            return false;
        }
        if (!left.is(JOINT_WEEDS) || !right.is(JOINT_WEEDS)) {
            return false;
        }
        if (mid.getItem() != this.tobaccoItem) {
            return false;
        }
        int nonEmpty = 0;
        for (int i = 0; i < input.size(); ++i) {
            if (input.getItem(i).isEmpty()) continue;
            ++nonEmpty;
        }
        return nonEmpty == 5;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        if (!this.hasPattern(input)) {
            return ItemStack.EMPTY;
        }
        ItemStack left = input.getItem(3);
        ItemStack right = input.getItem(5);
        ArrayList<ItemStack> weeds = new ArrayList<ItemStack>(2);
        weeds.add(left);
        weeds.add(right);
        ItemStack joint = new ItemStack((ItemLike)this.jointResult);
        JointItem.storeWeeds(joint, weeds);
        return joint;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w >= 3 && h >= 3;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)this.jointResult);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.JOINT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<JointRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<JointRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("tobacco").forGetter(r -> BuiltInRegistries.ITEM.getKey((Object)r.tobaccoItem)), (App)ResourceLocation.CODEC.fieldOf("result").forGetter(r -> BuiltInRegistries.ITEM.getKey((Object)r.jointResult)), (App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(CustomRecipe::category)).apply((Applicative)instance, (tobaccoRL, resultRL, cat) -> new JointRecipe((CraftingBookCategory)cat, (Item)BuiltInRegistries.ITEM.get(tobaccoRL), (Item)BuiltInRegistries.ITEM.get(resultRL))));
        private static final StreamCodec<RegistryFriendlyByteBuf, JointRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            buf.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)recipe.tobaccoItem));
            buf.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)recipe.jointResult));
            buf.writeEnum((Enum)recipe.category());
        }, buf -> {
            ResourceLocation tob = buf.readResourceLocation();
            ResourceLocation res = buf.readResourceLocation();
            CraftingBookCategory cat = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            return new JointRecipe(cat, (Item)BuiltInRegistries.ITEM.get(tob), (Item)BuiltInRegistries.ITEM.get(res));
        });

        public MapCodec<JointRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, JointRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

