/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.recipe.ManualGrinderInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record ManualGrinderRecipe(Ingredient ingredient, ItemStack result, int grindTime) implements Recipe<ManualGrinderInput>
{
    public boolean matches(ManualGrinderInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack assemble(ManualGrinderInput input, HolderLookup.Provider provider) {
        ItemStack out = this.result.copy();
        ItemStack in = input.getItem(0);
        if (!in.isEmpty()) {
            Item item = out.getItem();
            if (item instanceof BaseWeedItem) {
                BaseWeedItem weedItem = (BaseWeedItem)item;
                weedItem.initializeStack(out);
            }
            Integer thc = (Integer)in.get((DataComponentType)ModDataComponentTypes.THC.get());
            Integer cbd = (Integer)in.get((DataComponentType)ModDataComponentTypes.CBD.get());
            if (thc != null) {
                out.set((DataComponentType)ModDataComponentTypes.THC.get(), (Object)thc);
            }
            if (cbd != null) {
                out.set((DataComponentType)ModDataComponentTypes.CBD.get(), (Object)cbd);
            }
        }
        return out;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.MANUAL_GRINDER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.MANUAL_GRINDER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ManualGrinderRecipe> {
        public static final MapCodec<ManualGrinderRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(ManualGrinderRecipe::ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(ManualGrinderRecipe::result), (App)Codec.INT.optionalFieldOf("grind_time", (Object)40).forGetter(ManualGrinderRecipe::grindTime)).apply((Applicative)inst, ManualGrinderRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ManualGrinderRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ManualGrinderRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, ManualGrinderRecipe::result, (StreamCodec)ByteBufCodecs.VAR_INT, ManualGrinderRecipe::grindTime, ManualGrinderRecipe::new);

        public MapCodec<ManualGrinderRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ManualGrinderRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

