/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.screen.custom;

import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.block.entity.DryerBlockEntity;
import net.micaxs.smokeleaf.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class DryerMenu
extends AbstractContainerMenu {
    public final DryerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public DryerMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, DryerMenu.validateBlockEntity(inv.player.level().getBlockEntity(extraData.readBlockPos())), (ContainerData)new SimpleContainerData(2));
    }

    private static BlockEntity validateBlockEntity(BlockEntity be) {
        if (!(be instanceof DryerBlockEntity)) {
            throw new IllegalStateException("BlockEntity is not a DryerBlockEntity!");
        }
        DryerBlockEntity dryer = (DryerBlockEntity)be;
        return dryer;
    }

    public DryerMenu(int containerId, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.DRYER_MENU.get(), containerId);
        this.blockEntity = (DryerBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 0, 26, 33));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 1, 116, 33));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 22;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copy = sourceStack.copy();
        boolean PLAYER_INV_START = false;
        int PLAYER_INV_END = 26;
        int HOTBAR_START = 27;
        int HOTBAR_END = 35;
        int TE_START = 36;
        int TE_END = 37;
        if (index >= 36 && index <= 37) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
        } else {
            boolean insertedInTE = false;
            if (this.blockEntity.itemHandler.isItemValid(0, sourceStack) && this.moveItemStackTo(sourceStack, 36, 38, false)) {
                insertedInTE = true;
            }
            if (!insertedInTE) {
                if (index >= 0 && index <= 26) {
                    if (!this.moveItemStackTo(sourceStack, 27, 36, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (index >= 27 && index <= 35) {
                    if (!this.moveItemStackTo(sourceStack, 0, 27, false)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    return ItemStack.EMPTY;
                }
            }
        }
        if (sourceStack.isEmpty()) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceStack);
        return copy;
    }

    public boolean stillValid(Player pPlayer) {
        return DryerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocks.DRYER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

