/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.screen.custom;

import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.block.entity.LiquifierBlockEntity;
import net.micaxs.smokeleaf.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class LiquifierMenu
extends AbstractContainerMenu {
    public final LiquifierBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    public static final int BUTTON_FILL_FROM_BUCKET = 0;
    public static final int BUTTON_DRAIN_TO_BUCKET = 1;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 1;

    public LiquifierMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, LiquifierMenu.validateBlockEntity(inv.player.level().getBlockEntity(extraData.readBlockPos())), (ContainerData)new SimpleContainerData(2));
    }

    private static BlockEntity validateBlockEntity(BlockEntity be) {
        if (!(be instanceof LiquifierBlockEntity)) {
            throw new IllegalStateException("BlockEntity is not a LiquifierBlockEntity!");
        }
        LiquifierBlockEntity liquifier = (LiquifierBlockEntity)be;
        return liquifier;
    }

    public LiquifierMenu(int containerId, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.LIQUIFIER_MENU.get(), containerId);
        this.blockEntity = (LiquifierBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.itemHandler, 0, 30, 35));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 54;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            return this.tryEmptyContainerIntoTank(player);
        }
        if (id == 1) {
            return this.tryFillContainerFromTank(player);
        }
        return false;
    }

    private boolean tryEmptyContainerIntoTank(Player player) {
        FluidActionResult res;
        IFluidHandler tank = this.blockEntity.getTank(null);
        ItemStack carried = this.getCarried();
        if (!carried.isEmpty() && (res = FluidUtil.tryEmptyContainer((ItemStack)carried, (IFluidHandler)tank, (int)1000, (Player)player, (boolean)true)).isSuccess()) {
            this.setCarried(res.getResult());
            this.blockEntity.setChanged();
            this.broadcastChanges();
            return true;
        }
        if (this.tryEmptyHandIntoTank(player, InteractionHand.MAIN_HAND, tank)) {
            return true;
        }
        return this.tryEmptyHandIntoTank(player, InteractionHand.OFF_HAND, tank);
    }

    private boolean tryFillContainerFromTank(Player player) {
        FluidActionResult res;
        IFluidHandler tank = this.blockEntity.getTank(null);
        ItemStack carried = this.getCarried();
        if (!carried.isEmpty() && (res = FluidUtil.tryFillContainer((ItemStack)carried, (IFluidHandler)tank, (int)1000, (Player)player, (boolean)true)).isSuccess()) {
            this.setCarried(res.getResult());
            this.blockEntity.setChanged();
            this.broadcastChanges();
            return true;
        }
        if (this.tryFillHandFromTank(player, InteractionHand.MAIN_HAND, tank)) {
            return true;
        }
        return this.tryFillHandFromTank(player, InteractionHand.OFF_HAND, tank);
    }

    private boolean tryEmptyHandIntoTank(Player player, InteractionHand hand, IFluidHandler tank) {
        ItemStack held = player.getItemInHand(hand);
        if (held.isEmpty()) {
            return false;
        }
        FluidActionResult res = FluidUtil.tryEmptyContainer((ItemStack)held, (IFluidHandler)tank, (int)1000, (Player)player, (boolean)true);
        if (res.isSuccess()) {
            player.setItemInHand(hand, res.getResult());
            this.blockEntity.setChanged();
            this.broadcastChanges();
            return true;
        }
        return false;
    }

    private boolean tryFillHandFromTank(Player player, InteractionHand hand, IFluidHandler tank) {
        ItemStack held = player.getItemInHand(hand);
        if (held.isEmpty()) {
            return false;
        }
        FluidActionResult res = FluidUtil.tryFillContainer((ItemStack)held, (IFluidHandler)tank, (int)1000, (Player)player, (boolean)true);
        if (res.isSuccess()) {
            player.setItemInHand(hand, res.getResult());
            this.blockEntity.setChanged();
            this.broadcastChanges();
            return true;
        }
        return false;
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 37) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player pPlayer) {
        return LiquifierMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocks.LIQUIFIER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

