/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.screen.custom;

import net.micaxs.smokeleaf.Config;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.entity.BaseWeedCropBlockEntity;
import net.micaxs.smokeleaf.block.entity.GrowPotBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MagnifyingGlassScreen
extends Screen {
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/analyzer/analyzer_gui.png");
    private static final int TEX_W = 256;
    private static final int TEX_H = 256;
    private static final int GUI_W = 176;
    private static final int GUI_H = 142;
    private static final int BAR_W = 141;
    private static final int BAR_H = 5;
    private static final int BAR_U = 0;
    private static final int NITROGEN_BAR_BG_TEXTURE_Y = 236;
    private static final int NITROGEN_BAR_FG_TEXTURE_Y = 241;
    private static final int PHOSPHORUS_BAR_BG_TEXTURE_Y = 216;
    private static final int PHOSPHORUS_BAR_FG_TEXTURE_Y = 221;
    private static final int POTASSIUM_BAR_BG_TEXTURE_Y = 246;
    private static final int POTASSIUM_BAR_FG_TEXTURE_Y = 251;
    private static final int BUTTON_W = 11;
    private static final int BUTTON_H = 10;
    private static final int BUTTON_U = 176;
    private static final int BUTTON_V = 0;
    private static final int BUTTON_HOVER_U = 187;
    private static final int BUTTON_HOVER_V = 0;
    private static final int ICON_SIZE = 12;
    private static final int NITROGEN_ICON_U = 176;
    private static final int NITROGEN_ICON_V = 10;
    private static final int PHOSPHORUS_ICON_U = 176;
    private static final int PHOSPHORUS_ICON_V = 22;
    private static final int POTASSIUM_ICON_U = 176;
    private static final int POTASSIUM_ICON_V = 34;
    private static final int MAX_NUTRIENT = 25;
    private final BlockPos pos;

    public MagnifyingGlassScreen(BlockPos pos) {
        super((Component)Component.literal((String)"Plant Analyzer"));
        this.pos = pos;
    }

    protected void init() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        MutableComponent producesLine;
        int budVal;
        int cbdVal;
        int thcVal;
        int kTextLeft;
        int pTextLeft;
        int nTextLeft;
        int potassium_text_top;
        int phosphorus_text_top;
        int nitrogen_text_top;
        int potassium_text_right;
        int phosphorus_text_right;
        int nitrogen_text_right;
        MutableComponent potassium_value;
        MutableComponent phosphorus_value;
        MutableComponent nitrogen_value;
        ChatFormatting kColor;
        ChatFormatting pColor;
        ChatFormatting nColor;
        int kDiff;
        int pDiff;
        int nDiff;
        int potassium_fill_w;
        int phosphorus_fill_w;
        int nitrogen_fill_w;
        int potassium_perfect_val;
        int phosphorus_perfect_val;
        int nitrogen_perfect_val;
        Config.NutrientTarget optimalNutrients;
        int potassium_val;
        int phosphorus_val;
        int nitrogen_val;
        BlockEntity crop;
        BlockEntity be;
        BlockState stateAtPos;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int left = (this.width - 176) / 2;
        int top = (this.height - 142) / 2;
        guiGraphics.blit(BG_TEXTURE, left, top, 0.0f, 0.0f, 176, 142, 256, 256);
        this.drawScaledCentered(guiGraphics, (Component)Component.literal((String)"Nutrients"), this.width / 2, top + 10, 0xFFFFFF, 1.0f, false);
        int nitrogen_x = left + 8;
        int nitrogen_y = top + 26;
        int phosphorus_x = left + 8;
        int phosphorus_y = top + 51;
        int potassium_x = left + 8;
        int potassium_y = top + 76;
        guiGraphics.blit(BG_TEXTURE, nitrogen_x, nitrogen_y, 176.0f, 10.0f, 12, 12, 256, 256);
        guiGraphics.blit(BG_TEXTURE, phosphorus_x, phosphorus_y, 176.0f, 22.0f, 12, 12, 256, 256);
        guiGraphics.blit(BG_TEXTURE, potassium_x, potassium_y, 176.0f, 34.0f, 12, 12, 256, 256);
        int nitrogen_bar_x = left + 26;
        int nitrogen_bar_y = top + 36;
        int phosphorus_bar_x = left + 26;
        int phosphorus_bar_y = top + 61;
        int potassium_bar_x = left + 26;
        int potassium_bar_y = top + 86;
        guiGraphics.blit(BG_TEXTURE, nitrogen_bar_x, nitrogen_bar_y, 0.0f, 236.0f, 141, 5, 256, 256);
        guiGraphics.blit(BG_TEXTURE, phosphorus_bar_x, phosphorus_bar_y, 0.0f, 216.0f, 141, 5, 256, 256);
        guiGraphics.blit(BG_TEXTURE, potassium_bar_x, potassium_bar_y, 0.0f, 246.0f, 141, 5, 256, 256);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Nitrogen"), nitrogen_bar_x + 1, nitrogen_bar_y - 10, 0xBBBBBB, true);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Phosphorus"), phosphorus_bar_x + 1, phosphorus_bar_y - 10, 0xBBBBBB, true);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)"Potassium"), potassium_bar_x + 1, potassium_bar_y - 9, 0xBBBBBB, true);
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos bePos = this.pos;
        if (level != null && (stateAtPos = level.getBlockState(this.pos)).getBlock() instanceof BaseWeedCropBlock && ((Boolean)stateAtPos.getValue((Property)BaseWeedCropBlock.TOP)).booleanValue()) {
            bePos = this.pos.below();
        }
        if ((be = level.getBlockEntity(bePos)) instanceof BaseWeedCropBlockEntity) {
            crop = (BaseWeedCropBlockEntity)be;
            nitrogen_val = Mth.clamp((int)crop.getNitrogen(), (int)0, (int)25);
            phosphorus_val = Mth.clamp((int)crop.getPhosphorus(), (int)0, (int)25);
            potassium_val = Mth.clamp((int)crop.getPotassium(), (int)0, (int)25);
            optimalNutrients = crop.getOptimalNutrientsLevels();
            nitrogen_perfect_val = optimalNutrients.n;
            phosphorus_perfect_val = optimalNutrients.p;
            potassium_perfect_val = optimalNutrients.k;
            nitrogen_fill_w = (int)Math.round(141.0 * ((double)Mth.clamp((int)nitrogen_val, (int)0, (int)25) / 25.0));
            phosphorus_fill_w = (int)Math.round(141.0 * ((double)Mth.clamp((int)phosphorus_val, (int)0, (int)25) / 25.0));
            potassium_fill_w = (int)Math.round(141.0 * ((double)Mth.clamp((int)potassium_val, (int)0, (int)25) / 25.0));
            guiGraphics.blit(BG_TEXTURE, nitrogen_bar_x, nitrogen_bar_y, 0.0f, 241.0f, nitrogen_fill_w, 5, 256, 256);
            guiGraphics.blit(BG_TEXTURE, phosphorus_bar_x, phosphorus_bar_y, 0.0f, 221.0f, phosphorus_fill_w, 5, 256, 256);
            guiGraphics.blit(BG_TEXTURE, potassium_bar_x, potassium_bar_y, 0.0f, 251.0f, potassium_fill_w, 5, 256, 256);
            nDiff = Math.abs(nitrogen_val - nitrogen_perfect_val);
            pDiff = Math.abs(phosphorus_val - phosphorus_perfect_val);
            kDiff = Math.abs(potassium_val - potassium_perfect_val);
            ChatFormatting chatFormatting = nDiff == 0 ? ChatFormatting.GREEN : (nDiff == 1 ? ChatFormatting.GOLD : (nColor = nDiff == 2 ? ChatFormatting.RED : ChatFormatting.DARK_RED));
            ChatFormatting chatFormatting2 = pDiff == 0 ? ChatFormatting.GREEN : (pDiff == 1 ? ChatFormatting.GOLD : (pColor = pDiff == 2 ? ChatFormatting.RED : ChatFormatting.DARK_RED));
            kColor = kDiff == 0 ? ChatFormatting.GREEN : (kDiff == 1 ? ChatFormatting.GOLD : (kDiff == 2 ? ChatFormatting.RED : ChatFormatting.DARK_RED));
            nitrogen_value = Component.literal((String)("" + nitrogen_val)).withStyle(nColor).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("" + nitrogen_perfect_val)).withStyle(ChatFormatting.GREEN));
            phosphorus_value = Component.literal((String)("" + phosphorus_val)).withStyle(pColor).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("" + phosphorus_perfect_val)).withStyle(ChatFormatting.GREEN));
            potassium_value = Component.literal((String)("" + potassium_val)).withStyle(kColor).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("" + potassium_perfect_val)).withStyle(ChatFormatting.GREEN));
            nitrogen_text_right = nitrogen_bar_x + 141 - 2;
            phosphorus_text_right = phosphorus_bar_x + 141 - 2;
            potassium_text_right = potassium_bar_x + 141 - 2;
            nitrogen_text_top = nitrogen_bar_y - 10;
            phosphorus_text_top = phosphorus_bar_y - 10;
            potassium_text_top = potassium_bar_y - 9;
            nTextLeft = nitrogen_text_right - this.font.width((FormattedText)nitrogen_value);
            pTextLeft = phosphorus_text_right - this.font.width((FormattedText)phosphorus_value);
            kTextLeft = potassium_text_right - this.font.width((FormattedText)potassium_value);
            guiGraphics.drawString(this.font, (Component)nitrogen_value, nTextLeft, nitrogen_text_top, 0xFFFFFF, true);
            guiGraphics.drawString(this.font, (Component)phosphorus_value, pTextLeft, phosphorus_text_top, 0xFFFFFF, true);
            guiGraphics.drawString(this.font, (Component)potassium_value, kTextLeft, potassium_text_top, 0xFFFFFF, true);
            this.drawScaledCentered(guiGraphics, (Component)Component.literal((String)"Produces"), this.width / 2, top + 101, 0xFFFFFF, 1.0f, false);
            thcVal = crop.getThc();
            cbdVal = crop.getCbd();
            budVal = crop.getBudCount();
            producesLine = Component.literal((String)"").append((Component)Component.literal((String)"THC: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(thcVal)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"%").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"  ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"CBD: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(cbdVal)).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"%").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"  ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"BUDS: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(budVal)).withStyle(ChatFormatting.LIGHT_PURPLE));
            this.drawScaledCentered(guiGraphics, (Component)producesLine, this.width / 2, top + 117, 0xFFFFFF, 1.0f, true);
        }
        if (be instanceof GrowPotBlockEntity) {
            crop = (GrowPotBlockEntity)be;
            nitrogen_val = Mth.clamp((int)crop.getNitrogen(), (int)0, (int)25);
            phosphorus_val = Mth.clamp((int)crop.getPhosphorus(), (int)0, (int)25);
            potassium_val = Mth.clamp((int)crop.getPotassium(), (int)0, (int)25);
            optimalNutrients = crop.getOptimalNutrientsLevels();
            nitrogen_perfect_val = optimalNutrients.n;
            phosphorus_perfect_val = optimalNutrients.p;
            potassium_perfect_val = optimalNutrients.k;
            nitrogen_fill_w = (int)Math.round(141.0 * ((double)Mth.clamp((int)nitrogen_val, (int)0, (int)25) / 25.0));
            phosphorus_fill_w = (int)Math.round(141.0 * ((double)Mth.clamp((int)phosphorus_val, (int)0, (int)25) / 25.0));
            potassium_fill_w = (int)Math.round(141.0 * ((double)Mth.clamp((int)potassium_val, (int)0, (int)25) / 25.0));
            guiGraphics.blit(BG_TEXTURE, nitrogen_bar_x, nitrogen_bar_y, 0.0f, 241.0f, nitrogen_fill_w, 5, 256, 256);
            guiGraphics.blit(BG_TEXTURE, phosphorus_bar_x, phosphorus_bar_y, 0.0f, 221.0f, phosphorus_fill_w, 5, 256, 256);
            guiGraphics.blit(BG_TEXTURE, potassium_bar_x, potassium_bar_y, 0.0f, 251.0f, potassium_fill_w, 5, 256, 256);
            nDiff = Math.abs(nitrogen_val - nitrogen_perfect_val);
            pDiff = Math.abs(phosphorus_val - phosphorus_perfect_val);
            kDiff = Math.abs(potassium_val - potassium_perfect_val);
            ChatFormatting chatFormatting = nDiff == 0 ? ChatFormatting.GREEN : (nDiff == 1 ? ChatFormatting.GOLD : (nColor = nDiff == 2 ? ChatFormatting.RED : ChatFormatting.DARK_RED));
            ChatFormatting chatFormatting3 = pDiff == 0 ? ChatFormatting.GREEN : (pDiff == 1 ? ChatFormatting.GOLD : (pColor = pDiff == 2 ? ChatFormatting.RED : ChatFormatting.DARK_RED));
            kColor = kDiff == 0 ? ChatFormatting.GREEN : (kDiff == 1 ? ChatFormatting.GOLD : (kDiff == 2 ? ChatFormatting.RED : ChatFormatting.DARK_RED));
            nitrogen_value = Component.literal((String)("" + nitrogen_val)).withStyle(nColor).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("" + nitrogen_perfect_val)).withStyle(ChatFormatting.GREEN));
            phosphorus_value = Component.literal((String)("" + phosphorus_val)).withStyle(pColor).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("" + phosphorus_perfect_val)).withStyle(ChatFormatting.GREEN));
            potassium_value = Component.literal((String)("" + potassium_val)).withStyle(kColor).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("" + potassium_perfect_val)).withStyle(ChatFormatting.GREEN));
            nitrogen_text_right = nitrogen_bar_x + 141 - 2;
            phosphorus_text_right = phosphorus_bar_x + 141 - 2;
            potassium_text_right = potassium_bar_x + 141 - 2;
            nitrogen_text_top = nitrogen_bar_y - 10;
            phosphorus_text_top = phosphorus_bar_y - 10;
            potassium_text_top = potassium_bar_y - 9;
            nTextLeft = nitrogen_text_right - this.font.width((FormattedText)nitrogen_value);
            pTextLeft = phosphorus_text_right - this.font.width((FormattedText)phosphorus_value);
            kTextLeft = potassium_text_right - this.font.width((FormattedText)potassium_value);
            guiGraphics.drawString(this.font, (Component)nitrogen_value, nTextLeft, nitrogen_text_top, 0xFFFFFF, true);
            guiGraphics.drawString(this.font, (Component)phosphorus_value, pTextLeft, phosphorus_text_top, 0xFFFFFF, true);
            guiGraphics.drawString(this.font, (Component)potassium_value, kTextLeft, potassium_text_top, 0xFFFFFF, true);
            this.drawScaledCentered(guiGraphics, (Component)Component.literal((String)"Produces"), this.width / 2, top + 101, 0xFFFFFF, 1.0f, false);
            thcVal = crop.getThc();
            cbdVal = crop.getCbd();
            budVal = crop.getBudCount();
            producesLine = Component.literal((String)"").append((Component)Component.literal((String)"THC: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(thcVal)).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"%").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"  ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"CBD: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(cbdVal)).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"%").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"  ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"BUDS: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(budVal)).withStyle(ChatFormatting.LIGHT_PURPLE));
            this.drawScaledCentered(guiGraphics, (Component)producesLine, this.width / 2, top + 117, 0xFFFFFF, 1.0f, true);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void drawScaled(GuiGraphics g, Component text, int x, int y, int color, float scale) {
        g.pose().pushPose();
        g.pose().translate((float)x, (float)y, 0.0f);
        g.pose().scale(scale, scale, 1.0f);
        g.drawString(this.font, text, 0, 0, color, false);
        g.pose().popPose();
    }

    private void drawScaledCentered(GuiGraphics g, Component text, int centerX, int y, int color, float scale, boolean shadow) {
        int w = this.font.width((FormattedText)text);
        int left = (int)((float)centerX - (float)w * scale / 2.0f);
        g.pose().pushPose();
        g.pose().translate((float)left, (float)y, 0.0f);
        g.pose().scale(scale, scale, 1.0f);
        g.drawString(this.font, text, 0, 0, color, shadow);
        g.pose().popPose();
    }
}

