/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.item.custom.WeedDerivedItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WeedEffectHelper {
    public static void setWeedData(CraftingContainer container, ItemStack weedDerivedItem) {
        int finalDuration = 0;
        for (ItemStack ingredient : container.getItems()) {
            Item item = ingredient.getItem();
            if (!(item instanceof BaseWeedItem)) continue;
            BaseWeedItem weedItem = (BaseWeedItem)item;
            if (!(weedDerivedItem.getItem() instanceof WeedDerivedItem)) continue;
            float effectMultiplier = ((WeedDerivedItem)weedDerivedItem.getItem()).getEffectFactor();
            finalDuration += (int)((float)weedItem.getDuration() * effectMultiplier);
            Integer weedDerivedItemDuration = (Integer)weedDerivedItem.get(ModDataComponentTypes.EFFECT_DURATION);
            if (weedDerivedItemDuration != null) {
                weedDerivedItem.set(ModDataComponentTypes.EFFECT_DURATION, (Object)finalDuration);
            }
            weedDerivedItem.set(ModDataComponentTypes.ACTIVE_INGREDIENT, (Object)ingredient.getItem().getDescriptionId());
            WeedEffectHelper.nameWeedBasedItem(ingredient, weedDerivedItem);
        }
    }

    public static void nameWeedBasedItem(ItemStack weedStack, ItemStack weedBasedItem) {
        if (!(weedStack.getItem() instanceof BaseWeedItem)) {
            return;
        }
        Component weedNameComponent = weedStack.getItem().getName(weedStack);
        Component weedBasedItemName = weedBasedItem.getItem().getName(weedBasedItem);
        String weedName = weedNameComponent.getString().replace(" Weed", "").replace(" weed", "");
        weedBasedItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)weedName.concat(" ").concat(weedBasedItemName.getString())));
    }

    public static List<BaseWeedItem> jsonArrayToWeedList(JsonArray array) {
        ArrayList<BaseWeedItem> list = new ArrayList<BaseWeedItem>();
        if (array == null || array.isEmpty()) {
            return list;
        }
        for (JsonElement el : array) {
            Item item;
            ResourceLocation rl;
            String id = null;
            if (el.isJsonPrimitive() && el.getAsJsonPrimitive().isString()) {
                id = el.getAsString();
            } else if (el.isJsonObject() && el.getAsJsonObject().has("id")) {
                id = el.getAsJsonObject().get("id").getAsString();
            }
            if (id == null || (rl = ResourceLocation.tryParse((String)id)) == null || !((item = (Item)BuiltInRegistries.ITEM.getOptional(rl).orElse(null)) instanceof BaseWeedItem)) continue;
            BaseWeedItem weedItem = (BaseWeedItem)item;
            list.add(weedItem);
        }
        return list;
    }

    public static Component getEffectTooltip(MobEffect effect, int effectDuration, boolean showDuration) {
        if (showDuration) {
            int duration = effectDuration / 20;
            return Component.translatable((String)effect.getDescriptionId()).append(" ").append((Component)Component.literal((String)("(" + duration + "s)"))).withStyle(ChatFormatting.GREEN);
        }
        return Component.translatable((String)effect.getDescriptionId()).append(" ").append((Component)Component.literal((String)"(??)")).withStyle(ChatFormatting.GREEN);
    }

    public static Component getEffectTooltip(List<BaseWeedItem> activeIngredients, boolean showDuration) {
        MutableComponent result = Component.empty();
        boolean first = true;
        for (BaseWeedItem weed : activeIngredients) {
            if (!first) {
                result.append("\n");
            }
            result.append(WeedEffectHelper.getEffectTooltip(weed.getEffect(), weed.getDuration(), showDuration));
            first = false;
        }
        return result;
    }

    @Nullable
    public static BaseWeedItem getActiveWeedIngredient(ItemStack itemStack) {
        Item item;
        ResourceLocation id;
        String activeIngredient = (String)itemStack.get(ModDataComponentTypes.ACTIVE_INGREDIENT);
        if (activeIngredient != null && (id = ResourceLocation.tryParse((String)activeIngredient)) != null && (item = (Item)BuiltInRegistries.ITEM.get(id)) instanceof BaseWeedItem) {
            BaseWeedItem weed = (BaseWeedItem)item;
            return weed;
        }
        return null;
    }
}

