/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="smokeleafindustries")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<List<? extends UnmodifiableConfig>> PLANT_NUTRIENTS = BUILDER.defineListAllowEmpty("plant_nutrients", Config.defaultPlantNutrients(), Config::validatePlantNutrientsElement);
    static final ModConfigSpec SPEC = BUILDER.build();
    private static final Map<String, NutrientTarget> PLANT_NUTRIENTS_CACHE = new HashMap<String, NutrientTarget>();

    private static List<UnmodifiableConfig> defaultPlantNutrients() {
        ArrayList<UnmodifiableConfig> list = new ArrayList<UnmodifiableConfig>();
        list.add(Config.make("white_widow_crop", 11, 8, 10));
        list.add(Config.make("bubble_kush_crop", 12, 10, 18));
        list.add(Config.make("amnesia_haze_crop", 10, 13, 9));
        list.add(Config.make("blue_cookies_crop", 10, 13, 9));
        list.add(Config.make("ghost_train_crop", 13, 12, 10));
        list.add(Config.make("sour_diesel_crop", 11, 13, 10));
        list.add(Config.make("lemon_haze_crop", 9, 12, 15));
        list.add(Config.make("jack_herer_crop", 10, 15, 10));
        list.add(Config.make("grape_ape_crop", 15, 13, 15));
        list.add(Config.make("cotton_candy_crop", 10, 13, 9));
        list.add(Config.make("afghani_crop", 11, 10, 19));
        list.add(Config.make("lava_cake_crop", 14, 12, 11));
        list.add(Config.make("jelly_rancher_crop", 11, 14, 9));
        list.add(Config.make("strawberry_shortcake_crop", 14, 11, 15));
        list.add(Config.make("purple_haze_crop", 11, 13, 7));
        list.add(Config.make("blue_ice_crop", 14, 9, 14));
        list.add(Config.make("bubblegum_crop", 14, 14, 12));
        list.add(Config.make("gary_peyton_crop", 14, 15, 9));
        list.add(Config.make("ak47_crop", 17, 8, 11));
        list.add(Config.make("banana_kush_crop", 15, 13, 15));
        list.add(Config.make("pink_kush_crop", 17, 9, 12));
        list.add(Config.make("og_kush_crop", 12, 13, 15));
        list.add(Config.make("carbon_fiber_crop", 14, 13, 20));
        list.add(Config.make("birthday_cake_crop", 11, 13, 16));
        list.add(Config.make("moonbow_crop", 15, 2, 22));
        return List.copyOf(list);
    }

    private static UnmodifiableConfig make(String cropName, int n, int p, int k) {
        com.electronwill.nightconfig.core.Config inner = com.electronwill.nightconfig.core.Config.inMemory();
        inner.set("n", (Object)n);
        inner.set("p", (Object)p);
        inner.set("k", (Object)k);
        com.electronwill.nightconfig.core.Config outer = com.electronwill.nightconfig.core.Config.inMemory();
        outer.set(cropName, (Object)inner);
        return outer.unmodifiable();
    }

    private static boolean validatePlantNutrientsElement(Object o) {
        if (!(o instanceof UnmodifiableConfig)) {
            return false;
        }
        UnmodifiableConfig outer = (UnmodifiableConfig)o;
        Map outerMap = outer.valueMap();
        if (outerMap.isEmpty() || outerMap.size() != 1) {
            return false;
        }
        Map.Entry entry = outerMap.entrySet().iterator().next();
        Object innerObj = entry.getValue();
        if (!(innerObj instanceof UnmodifiableConfig)) {
            return false;
        }
        UnmodifiableConfig inner = (UnmodifiableConfig)innerObj;
        Object n = inner.get("n");
        Object p = inner.get("p");
        Object k = inner.get("k");
        return Config.isIntLike(n) && Config.isIntLike(p) && Config.isIntLike(k);
    }

    private static boolean isIntLike(Object o) {
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                Integer.parseInt(s);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static int toInt(Object o, int def) {
        if (o instanceof Number) {
            Number num = (Number)o;
            return num.intValue();
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private static void rebuildPlantNutrientsCache() {
        PLANT_NUTRIENTS_CACHE.clear();
        List list = (List)PLANT_NUTRIENTS.get();
        if (list == null) {
            return;
        }
        for (UnmodifiableConfig outer : list) {
            Map outerMap;
            if (outer == null || (outerMap = outer.valueMap()).isEmpty()) continue;
            Map.Entry e = outerMap.entrySet().iterator().next();
            String key = (String)e.getKey();
            Object innerObj = e.getValue();
            if (!(innerObj instanceof UnmodifiableConfig)) continue;
            UnmodifiableConfig inner = (UnmodifiableConfig)innerObj;
            int n = Config.toInt(inner.get("n"), 0);
            int p = Config.toInt(inner.get("p"), 0);
            int k = Config.toInt(inner.get("k"), 0);
            NutrientTarget target = new NutrientTarget(n, p, k);
            PLANT_NUTRIENTS_CACHE.put(key, target);
            try {
                ResourceLocation rl = ResourceLocation.parse((String)key);
                PLANT_NUTRIENTS_CACHE.putIfAbsent(rl.getPath(), target);
            }
            catch (Exception exception) {}
        }
    }

    public static Optional<NutrientTarget> getNutrientTargetFor(ResourceLocation id) {
        if (id == null) {
            return Optional.empty();
        }
        NutrientTarget t = PLANT_NUTRIENTS_CACHE.get(id.toString());
        if (t != null) {
            return Optional.of(t);
        }
        t = PLANT_NUTRIENTS_CACHE.get(id.getPath());
        return Optional.ofNullable(t);
    }

    @SubscribeEvent
    static void onConfigLoadOrReload(ModConfigEvent event) {
        Config.rebuildPlantNutrientsCache();
    }

    public static final class NutrientTarget {
        public final int n;
        public final int p;
        public final int k;

        public NutrientTarget(int n, int p, int k) {
            this.n = n;
            this.p = p;
            this.k = k;
        }
    }
}

