/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.entity.GrowPotBlockEntity;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.item.custom.FertilizerItem;
import net.micaxs.smokeleaf.item.custom.PlantAnalyzerItem;
import net.micaxs.smokeleaf.screen.custom.MagnifyingGlassScreen;
import net.micaxs.smokeleaf.utils.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GrowPotBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<GrowPotBlock> CODEC = GrowPotBlock.simpleCodec(GrowPotBlock::new);

    public GrowPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)1.0, (double)0.0, (double)1.0, (double)14.0, (double)8.0, (double)14.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GrowPotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : GrowPotBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.GROW_POT.get()), GrowPotBlockEntity::tick);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item;
        BaseWeedCropBlock crop;
        ServerLevel serverLevel;
        BlockItem bi;
        Item item2;
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof GrowPotBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        GrowPotBlockEntity pot = (GrowPotBlockEntity)be;
        boolean holdingBoneMeal = !stack.isEmpty() && stack.is(Items.BONE_MEAL);
        boolean holdingMagnifyingGlass = !stack.isEmpty() && stack.getItem() instanceof PlantAnalyzerItem;
        boolean holdingFertilizer = !stack.isEmpty() && stack.getItem() instanceof FertilizerItem;
        boolean canInsertSoil = !pot.hasSoil() && (item2 = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item2).getBlock().builtInRegistryHolder().is(ModTags.POT_SOILS);
        boolean canPlantCrop = pot.hasSoil() && !pot.hasCrop() && stack.is(ModTags.WEED_SEEDS) && GrowPotBlockEntity.resolveCropBySeed(stack.getItem()) != null;
        boolean canFertilize = pot.hasCrop() && holdingFertilizer && !pot.canHarvest();
        boolean tryingFertilizeFullyGrown = pot.hasCrop() && holdingFertilizer && pot.canHarvest();
        boolean canBonemeal = pot.hasCrop() && holdingBoneMeal;
        boolean canHarvest = pot.canHarvest();
        boolean emptyHand = stack.isEmpty();
        boolean sneaking = player.isShiftKeyDown();
        if (holdingMagnifyingGlass) {
            if (level.isClientSide()) {
                Minecraft.getInstance().setScreen((Screen)new MagnifyingGlassScreen(pos));
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (level.isClientSide) {
            if (sneaking && emptyHand && (pot.hasCrop() || pot.hasSoil()) || canInsertSoil || canPlantCrop || canFertilize || canBonemeal || canHarvest || tryingFertilizeFullyGrown) {
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (sneaking && emptyHand && level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (pot.hasCrop() ? pot.removeCropAndGiveSeed(serverLevel, player) : pot.hasSoil() && pot.removeSoilAndGiveBack(serverLevel, player)) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (tryingFertilizeFullyGrown) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"tooltip.smokeleafindustries.add_fertilizer"), true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (canInsertSoil) {
            Block soilBlock = ((BlockItem)stack.getItem()).getBlock();
            pot.setSoil(soilBlock.defaultBlockState());
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            pot.setChangedAndSync();
            return ItemInteractionResult.SUCCESS;
        }
        if (canPlantCrop && (crop = GrowPotBlockEntity.resolveCropBySeed(stack.getItem())) != null) {
            pot.initFromCrop(crop);
            pot.plantCrop(crop);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            pot.setChangedAndSync();
            return ItemInteractionResult.SUCCESS;
        }
        if (canFertilize && (item = stack.getItem()) instanceof FertilizerItem) {
            FertilizerItem fert = (FertilizerItem)item;
            pot.addNitrogen(fert.getN());
            pot.addPhosphorus(fert.getP());
            pot.addPotassium(fert.getK());
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            pot.setChangedAndSync();
            return ItemInteractionResult.SUCCESS;
        }
        if (canBonemeal && pot.applyBonemeal(level)) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.levelEvent(1505, pos, 0);
            pot.setChangedAndSync();
            return ItemInteractionResult.SUCCESS;
        }
        if (canHarvest && level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            pot.harvest(serverLevel);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)"Instructions:").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.grow_pot.soil").withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.grow_pot.plant").withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.grow_pot.info").withStyle(ChatFormatting.DARK_GRAY));
    }
}

