/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.recipe.DryingRecipe;
import net.micaxs.smokeleaf.recipe.DryingRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.screen.custom.DryerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryerBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            DryerBlockEntity.this.setChanged();
            if (!DryerBlockEntity.this.level.isClientSide()) {
                DryerBlockEntity.this.level.sendBlockUpdated(DryerBlockEntity.this.getBlockPos(), DryerBlockEntity.this.getBlockState(), DryerBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot != 0) {
                return false;
            }
            if (stack.isEmpty() || DryerBlockEntity.this.level == null) {
                return false;
            }
            return DryerBlockEntity.this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.DRYING_TYPE.get(), (RecipeInput)new DryingRecipeInput(stack), DryerBlockEntity.this.level).filter(r -> DryerBlockEntity.this.acceptsForMachine((DryingRecipe)r.value())).isPresent();
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 38;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.itemHandler;
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(64000, 320){

            @Override
            public void onEnergyChanged() {
                DryerBlockEntity.this.setChanged();
                if (DryerBlockEntity.this.getLevel() != null) {
                    DryerBlockEntity.this.getLevel().sendBlockUpdated(DryerBlockEntity.this.getBlockPos(), DryerBlockEntity.this.getBlockState(), DryerBlockEntity.this.getBlockState(), 1);
                }
            }
        };
    }

    public DryerBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.DRYER_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> DryerBlockEntity.this.progress;
                    case 1 -> DryerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        DryerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        DryerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public ItemStack getRenderStack() {
        if (this.itemHandler.getStackInSlot(1).isEmpty()) {
            return this.itemHandler.getStackInSlot(0);
        }
        return this.itemHandler.getStackInSlot(1);
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Dryer");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new DryerMenu(i, inventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        boolean shouldBePowered;
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean hasEnergy = this.ENERGY_STORAGE.getEnergyStored() > 0;
        Optional<RecipeHolder<DryingRecipe>> recipeOpt = this.getCurrentRecipe();
        Optional plannedOutput = recipeOpt.flatMap(this::getPlannedOutput);
        boolean canOutput = plannedOutput.filter(this::canInsertIntoOutput).isPresent();
        if (hasEnergy && recipeOpt.isPresent() && canOutput) {
            this.maxProgress = Math.max(1, ((DryingRecipe)recipeOpt.get().value()).time() / 3);
            this.increaseCraftingProgress();
            this.ENERGY_STORAGE.extractEnergy(20, false);
            if (level.random.nextInt(2) == 0) {
                double x = (double)blockPos.getX() + 0.5;
                double y = (double)blockPos.getY() + 1.0;
                double z = (double)blockPos.getZ() + 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
            DryerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (this.hasProgressFinished()) {
                this.craftItem(recipeOpt.get(), (ItemStack)plannedOutput.get());
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            DryerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        boolean bl = shouldBePowered = this.progress > 0 || hasEnergy && recipeOpt.isPresent() && canOutput;
        if ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) != shouldBePowered) {
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)));
        }
    }

    private boolean acceptsForMachine(DryingRecipe recipe) {
        return !recipe.result().isEmpty() || recipe.dryBud();
    }

    private Optional<RecipeHolder<DryingRecipe>> getCurrentRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        ItemStack in = this.itemHandler.getStackInSlot(0);
        if (in.isEmpty()) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.DRYING_TYPE.get(), (RecipeInput)new DryingRecipeInput(in), this.level).filter(r -> this.acceptsForMachine((DryingRecipe)r.value()));
    }

    private Optional<ItemStack> getPlannedOutput(RecipeHolder<DryingRecipe> recipeHolder) {
        ItemStack in = this.itemHandler.getStackInSlot(0);
        if (in.isEmpty()) {
            return Optional.empty();
        }
        DryingRecipe recipe = (DryingRecipe)recipeHolder.value();
        if (!recipe.result().isEmpty()) {
            ItemStack out = recipe.result().copy();
            out.setCount(Math.max(1, out.getCount()));
            return Optional.of(out);
        }
        if (recipe.dryBud()) {
            ItemStack dried = in.copy();
            dried.setCount(1);
            dried.set(ModDataComponentTypes.DRY, (Object)true);
            return Optional.of(dried);
        }
        return Optional.empty();
    }

    private boolean canInsertIntoOutput(ItemStack planned) {
        ItemStack existing = this.itemHandler.getStackInSlot(1);
        if (existing.isEmpty()) {
            return planned.getCount() <= planned.getMaxStackSize();
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)planned)) {
            return false;
        }
        int max = Math.min(existing.getMaxStackSize(), planned.getMaxStackSize());
        return existing.getCount() + planned.getCount() <= max;
    }

    private void craftItem(RecipeHolder<DryingRecipe> recipe, ItemStack plannedOutput) {
        this.itemHandler.extractItem(0, 1, false);
        ItemStack existing = this.itemHandler.getStackInSlot(1);
        if (existing.isEmpty()) {
            this.itemHandler.setStackInSlot(1, plannedOutput.copy());
        } else if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)plannedOutput)) {
            int newCount = Math.min(existing.getCount() + plannedOutput.getCount(), existing.getMaxStackSize());
            existing.setCount(newCount);
            this.itemHandler.setStackInSlot(1, existing);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("dryer.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("dryer.progress", this.progress);
        tag.putInt("dryer.maxProgress", this.maxProgress);
        tag.putInt("dryer.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("dryer.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("dryer.energy"));
        this.progress = tag.getInt("dryer.progress");
        this.maxProgress = tag.getInt("dryer.maxProgress");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

