/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.recipe.ExtractorRecipe;
import net.micaxs.smokeleaf.recipe.ExtractorRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.screen.custom.ExtractorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractorBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            ExtractorBlockEntity.this.setChanged();
            if (!ExtractorBlockEntity.this.level.isClientSide()) {
                ExtractorBlockEntity.this.level.sendBlockUpdated(ExtractorBlockEntity.this.getBlockPos(), ExtractorBlockEntity.this.getBlockState(), ExtractorBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot != 0) {
                return false;
            }
            if (stack.isEmpty() || ExtractorBlockEntity.this.level == null) {
                return false;
            }
            return ExtractorBlockEntity.this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.EXTRACTOR_TYPE.get(), (RecipeInput)new ExtractorRecipeInput(stack), ExtractorBlockEntity.this.level).isPresent();
        }
    };
    private static final int ENERGY_CONSTANT = 40;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 78;
    private static final int ENERGY_TRANSFER_AMOUNT = 320;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.itemHandler;
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(64000, 320){

            @Override
            public void onEnergyChanged() {
                ExtractorBlockEntity.this.setChanged();
                ExtractorBlockEntity.this.getLevel().sendBlockUpdated(ExtractorBlockEntity.this.getBlockPos(), ExtractorBlockEntity.this.getBlockState(), ExtractorBlockEntity.this.getBlockState(), 1);
            }
        };
    }

    public ExtractorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.EXTRACTOR_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> ExtractorBlockEntity.this.progress;
                    case 1 -> ExtractorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        ExtractorBlockEntity.this.progress = value;
                    }
                    case 1: {
                        ExtractorBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public ItemStack getRenderStack() {
        if (this.itemHandler.getStackInSlot(1).isEmpty()) {
            return this.itemHandler.getStackInSlot(0);
        }
        return this.itemHandler.getStackInSlot(1);
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Weed Extractor");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ExtractorMenu(i, inventory, this, this.data);
    }

    private ItemStack buildOutputWithWeedData(ItemStack input, ItemStack recipeOutput) {
        String eff;
        Integer cbd;
        ItemStack result = new ItemStack((ItemLike)recipeOutput.getItem(), recipeOutput.getCount());
        Integer thc = (Integer)input.get((DataComponentType)ModDataComponentTypes.THC.get());
        if (thc != null) {
            result.set((DataComponentType)ModDataComponentTypes.THC.get(), (Object)thc);
        }
        if ((cbd = (Integer)input.get((DataComponentType)ModDataComponentTypes.CBD.get())) != null) {
            result.set((DataComponentType)ModDataComponentTypes.CBD.get(), (Object)cbd);
        }
        if ((eff = (String)input.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get())) != null) {
            result.set((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get(), (Object)eff);
        }
        return result;
    }

    private boolean areWeedDataEqual(ItemStack a, ItemStack b) {
        Integer bCBD;
        Integer bTHC;
        Integer aTHC = (Integer)a.get((DataComponentType)ModDataComponentTypes.THC.get());
        if (!Objects.equals(aTHC, bTHC = (Integer)b.get((DataComponentType)ModDataComponentTypes.THC.get()))) {
            return false;
        }
        Integer aCBD = (Integer)a.get((DataComponentType)ModDataComponentTypes.CBD.get());
        if (!Objects.equals(aCBD, bCBD = (Integer)b.get((DataComponentType)ModDataComponentTypes.CBD.get()))) {
            return false;
        }
        String aEff = (String)a.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get());
        String bEff = (String)b.get((DataComponentType)ModDataComponentTypes.ACTIVE_INGREDIENT.get());
        return Objects.equals(aEff, bEff);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        boolean shouldBePowered;
        boolean hasEnergy;
        boolean bl = hasEnergy = this.ENERGY_STORAGE.getEnergyStored() > 0;
        if (hasEnergy && this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.ENERGY_STORAGE.extractEnergy(20, false);
            if (level.random.nextInt(2) == 0) {
                double x = (double)blockPos.getX() + 0.5;
                double y = (double)blockPos.getY() + 1.0;
                double z = (double)blockPos.getZ() + 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
            ExtractorBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            ExtractorBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        boolean bl2 = shouldBePowered = this.progress > 0 || hasEnergy && this.hasRecipe();
        if ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) != shouldBePowered) {
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)));
        }
    }

    private boolean hasRecipe() {
        ItemStack recipeOut;
        Optional<RecipeHolder<ExtractorRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack candidate = this.buildOutputWithWeedData(input, recipeOut = ((ExtractorRecipe)recipe.get().value()).output());
        return this.canInsertAmountIntoOutputSlot(candidate.getCount()) && this.canInsertItemIntoOutputSlot(candidate);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack candidate) {
        ItemStack slot = this.itemHandler.getStackInSlot(1);
        if (slot.isEmpty()) {
            return true;
        }
        if (slot.getItem() != candidate.getItem()) {
            return false;
        }
        return this.areWeedDataEqual(slot, candidate);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.itemHandler.getStackInSlot(1).isEmpty() ? 64 : this.itemHandler.getStackInSlot(1).getMaxStackSize();
        int currentCount = this.itemHandler.getStackInSlot(1).getCount();
        return maxCount >= currentCount + count;
    }

    private Optional<RecipeHolder<ExtractorRecipe>> getCurrentRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.EXTRACTOR_TYPE.get(), (RecipeInput)new ExtractorRecipeInput(this.itemHandler.getStackInSlot(0)), this.level);
    }

    private void craftItem() {
        Optional<RecipeHolder<ExtractorRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack recipeOut = ((ExtractorRecipe)recipe.get().value()).output();
        ItemStack candidate = this.buildOutputWithWeedData(input, recipeOut);
        this.itemHandler.extractItem(0, 1, false);
        ItemStack outSlot = this.itemHandler.getStackInSlot(1);
        if (outSlot.isEmpty()) {
            this.itemHandler.setStackInSlot(1, candidate);
        } else {
            ItemStack merged = outSlot.copy();
            merged.grow(candidate.getCount());
            this.itemHandler.setStackInSlot(1, merged);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("extractor.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("extractor.progress", this.progress);
        tag.putInt("extractor.maxProgress", this.maxProgress);
        tag.putInt("extractor.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("extractor.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("extractor.energy"));
        this.progress = tag.getInt("extractor.progress");
        this.maxProgress = tag.getInt("extractor.maxProgress");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

