/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.micaxs.smokeleaf.recipe.GrinderRecipe;
import net.micaxs.smokeleaf.recipe.GrinderRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.screen.custom.GrinderMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrinderBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            GrinderBlockEntity.this.setChanged();
            if (!GrinderBlockEntity.this.level.isClientSide()) {
                GrinderBlockEntity.this.level.sendBlockUpdated(GrinderBlockEntity.this.getBlockPos(), GrinderBlockEntity.this.getBlockState(), GrinderBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot != 0) {
                return false;
            }
            if (stack.isEmpty() || GrinderBlockEntity.this.level == null) {
                return false;
            }
            return GrinderBlockEntity.this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.GRINDER_TYPE.get(), (RecipeInput)new GrinderRecipeInput(stack), GrinderBlockEntity.this.level).isPresent();
        }
    };
    private static final int ENERGY_CONSTANT = 40;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 78;
    private static final int ENERGY_TRANSFER_AMOUNT = 320;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.itemHandler;
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(64000, 320){

            @Override
            public void onEnergyChanged() {
                GrinderBlockEntity.this.setChanged();
                GrinderBlockEntity.this.getLevel().sendBlockUpdated(GrinderBlockEntity.this.getBlockPos(), GrinderBlockEntity.this.getBlockState(), GrinderBlockEntity.this.getBlockState(), 1);
            }
        };
    }

    public GrinderBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.GRINDER_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> GrinderBlockEntity.this.progress;
                    case 1 -> GrinderBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        GrinderBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        GrinderBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public ItemStack getRenderStack() {
        if (this.itemHandler.getStackInSlot(1).isEmpty()) {
            return this.itemHandler.getStackInSlot(0);
        }
        return this.itemHandler.getStackInSlot(1);
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Weed Grinder");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new GrinderMenu(i, inventory, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        boolean shouldBePowered;
        boolean hasEnergy;
        boolean bl = hasEnergy = this.ENERGY_STORAGE.getEnergyStored() > 0;
        if (hasEnergy && this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.ENERGY_STORAGE.extractEnergy(20, false);
            if (level.random.nextInt(2) == 0) {
                double x = (double)blockPos.getX() + 0.5;
                double y = (double)blockPos.getY() + 1.0;
                double z = (double)blockPos.getZ() + 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            }
            GrinderBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
            GrinderBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        boolean bl2 = shouldBePowered = this.progress > 0 || hasEnergy && this.hasRecipe();
        if ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) != shouldBePowered) {
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)));
        }
    }

    private boolean hasRecipe() {
        int totalOut;
        Optional<RecipeHolder<GrinderRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack assembled = ((GrinderRecipe)recipe.get().value()).assemble(new GrinderRecipeInput(input.copyWithCount(1)), (HolderLookup.Provider)this.level.registryAccess());
        int bonus = 0;
        if (input.getItem() instanceof BaseBudItem && Boolean.TRUE.equals(input.get(ModDataComponentTypes.DRY))) {
            bonus = 1;
        }
        return this.canInsertAmountIntoOutputSlot(totalOut = assembled.getCount() + bonus) && this.canInsertItemIntoOutputSlot(assembled);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        ItemStack existing = this.itemHandler.getStackInSlot(1);
        return existing.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)output);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.itemHandler.getStackInSlot(1).isEmpty() ? 64 : this.itemHandler.getStackInSlot(1).getMaxStackSize();
        int currentCount = this.itemHandler.getStackInSlot(1).getCount();
        return maxCount >= currentCount + count;
    }

    private Optional<RecipeHolder<GrinderRecipe>> getCurrentRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.GRINDER_TYPE.get(), (RecipeInput)new GrinderRecipeInput(this.itemHandler.getStackInSlot(0)), this.level);
    }

    private void craftItem() {
        Optional<RecipeHolder<GrinderRecipe>> recipeOpt = this.getCurrentRecipe();
        if (recipeOpt.isEmpty()) {
            return;
        }
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        ItemStack result = ((GrinderRecipe)recipeOpt.get().value()).assemble(new GrinderRecipeInput(inputStack.copyWithCount(1)), (HolderLookup.Provider)this.level.registryAccess());
        int bonus = 0;
        if (inputStack.getItem() instanceof BaseBudItem && Boolean.TRUE.equals(inputStack.get(ModDataComponentTypes.DRY))) {
            bonus = 1;
        }
        int totalProduced = result.getCount() + bonus;
        ItemStack existing = this.itemHandler.getStackInSlot(1);
        boolean inserted = false;
        if (existing.isEmpty()) {
            result.setCount(Math.min(totalProduced, result.getMaxStackSize()));
            this.itemHandler.setStackInSlot(1, result);
            inserted = true;
        } else if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)result)) {
            int newCount = Math.min(existing.getCount() + totalProduced, existing.getMaxStackSize());
            existing.setCount(newCount);
            this.itemHandler.setStackInSlot(1, existing);
            inserted = true;
        }
        if (inserted) {
            this.itemHandler.extractItem(0, 1, false);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("grinder.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("grinder.progress", this.progress);
        tag.putInt("grinder.maxProgress", this.maxProgress);
        tag.putInt("grinder.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("grinder.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("grinder.energy"));
        this.progress = tag.getInt("grinder.progress");
        this.maxProgress = tag.getInt("grinder.maxProgress");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

