/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.micaxs.smokeleaf.Config;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.item.custom.BaseBudItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrowPotBlockEntity
extends BlockEntity {
    public static int FULL_GROWTH_SECONDS_FAST = 60;
    public static int FULL_GROWTH_SECONDS_SLOW = 90;
    private static final int MAX_PERCENT = 100;
    private static final int MAX_PH = 14;
    @Nullable
    private BlockState soilState;
    @Nullable
    private BaseWeedCropBlock cropBlock;
    private int cropAge;
    private int growthProgressTicks;
    private int thc;
    private int cbd;
    private int ph;
    private int nitrogen;
    private int phosphorus;
    private int potassium;

    public GrowPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GROW_POT.get(), pos, state);
    }

    public void initFromCrop(BaseWeedCropBlock crop) {
        this.thc = crop.getBaseThc();
        this.cbd = crop.getBaseCbd();
        this.nitrogen = crop.getBaseN();
        this.phosphorus = crop.getBaseP();
        this.potassium = crop.getBaseK();
        this.ph = crop.getBasePh();
    }

    public void setThc(int v) {
        this.thc = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setCbd(int v) {
        this.cbd = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setPh(int v) {
        this.ph = Mth.clamp((int)v, (int)0, (int)14);
    }

    public void setNitrogen(int v) {
        this.nitrogen = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setPhosphorus(int v) {
        this.phosphorus = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void setPotassium(int v) {
        this.potassium = Mth.clamp((int)v, (int)0, (int)100);
    }

    public void addNitrogen(int d) {
        this.setNitrogen(this.nitrogen + d);
    }

    public void addPhosphorus(int d) {
        this.setPhosphorus(this.phosphorus + d);
    }

    public void addPotassium(int d) {
        this.setPotassium(this.potassium + d);
    }

    public void addPh(int d) {
        this.setPh(this.ph + d);
    }

    public int getNitrogen() {
        return this.nitrogen;
    }

    public int getPhosphorus() {
        return this.phosphorus;
    }

    public int getPotassium() {
        return this.potassium;
    }

    public int getCropAge() {
        return this.cropAge;
    }

    public int getCropMaxAge() {
        return this.cropBlock != null ? this.cropBlock.getMaxAge() : 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GrowPotBlockEntity be) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (!be.hasCrop()) {
            return;
        }
        int light = level.getMaxLocalRawBrightness(pos.above());
        if (light < 12) {
            return;
        }
        int maxAge = be.cropBlock.getMaxAge();
        if (be.cropAge >= maxAge) {
            return;
        }
        int fullGrowthTicks = be.getFullGrowthTicksForSoil();
        int perStepTicks = Math.max(1, fullGrowthTicks / Math.max(1, maxAge));
        int startAge = be.cropAge;
        ++be.growthProgressTicks;
        while (be.growthProgressTicks >= perStepTicks && be.cropAge < maxAge) {
            be.growthProgressTicks -= perStepTicks;
            ++be.cropAge;
        }
        if (be.cropAge != startAge) {
            be.setChangedAndSync();
        }
    }

    private int getFullGrowthTicksForSoil() {
        boolean fast = this.soilState != null && this.soilState.getBlock() instanceof FarmBlock;
        int seconds = fast ? FULL_GROWTH_SECONDS_FAST : FULL_GROWTH_SECONDS_SLOW;
        return Math.max(1, seconds * 20);
    }

    public boolean hasSoil() {
        return this.soilState != null;
    }

    public boolean hasCrop() {
        return this.cropBlock != null;
    }

    public void setSoil(BlockState soil) {
        this.soilState = soil;
        this.setChangedAndSync();
    }

    public void clearSoil() {
        this.soilState = null;
        this.clearCrop();
    }

    public void plantCrop(BaseWeedCropBlock crop) {
        this.cropBlock = crop;
        this.cropAge = 0;
        this.growthProgressTicks = 0;
        this.initFromCrop(crop);
        this.setChangedAndSync();
    }

    public void clearCrop() {
        this.cropBlock = null;
        this.cropAge = 0;
        this.growthProgressTicks = 0;
        this.potassium = 0;
        this.phosphorus = 0;
        this.nitrogen = 0;
        this.ph = 0;
        this.cbd = 0;
        this.thc = 0;
        this.setChangedAndSync();
    }

    @Nullable
    public BlockState getSoilState() {
        return this.soilState;
    }

    @Nullable
    public BlockState getBottomCropStateForRender() {
        if (this.cropBlock == null) {
            return null;
        }
        return (BlockState)((BlockState)this.cropBlock.defaultBlockState().setValue((Property)BaseWeedCropBlock.AGE, (Comparable)Integer.valueOf(Math.min(this.cropAge, this.cropBlock.getMaxAge())))).setValue((Property)this.cropBlock.getTop(), (Comparable)Boolean.FALSE);
    }

    @Nullable
    public BlockState getTopCropStateForRender() {
        if (this.cropBlock == null) {
            return null;
        }
        int tallAge = this.cropBlock.getTallAge();
        if (this.cropAge < tallAge) {
            return null;
        }
        return (BlockState)((BlockState)this.cropBlock.defaultBlockState().setValue((Property)BaseWeedCropBlock.AGE, (Comparable)Integer.valueOf(Math.min(this.cropAge, this.cropBlock.getMaxAge())))).setValue((Property)this.cropBlock.getTop(), (Comparable)Boolean.TRUE);
    }

    public boolean canHarvest() {
        return this.hasCrop() && this.cropAge >= this.cropBlock.getMaxAge();
    }

    public boolean applyBonemeal(Level level) {
        if (!this.hasCrop()) {
            return false;
        }
        int maxAge = this.cropBlock.getMaxAge();
        if (this.cropAge >= maxAge) {
            return false;
        }
        int inc = Mth.nextInt((RandomSource)level.random, (int)2, (int)5);
        int newAge = Math.min(maxAge, this.cropAge + inc);
        if (newAge != this.cropAge) {
            this.cropAge = newAge;
            this.growthProgressTicks = 0;
            return true;
        }
        return false;
    }

    public void harvest(ServerLevel serverLevel) {
        if (!this.canHarvest()) {
            return;
        }
        BlockState lootState = (BlockState)((BlockState)this.cropBlock.defaultBlockState().setValue((Property)BaseWeedCropBlock.AGE, (Comparable)Integer.valueOf(this.cropBlock.getMaxAge()))).setValue((Property)this.cropBlock.getTop(), (Comparable)Boolean.FALSE);
        LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(lootState.getDrops(builder));
        Item seedItem = this.cropBlock.getBaseSeedId().asItem();
        drops.removeIf(stk -> stk.is(seedItem));
        int budFactor = this.getBudCount();
        int thcVal = this.getThc();
        int cbdVal = this.getCbd();
        for (ItemStack drop : drops) {
            if (!(drop.getItem() instanceof BaseBudItem)) continue;
            if (drop.getCount() > 0 && budFactor > 1) {
                drop.setCount(drop.getCount() * budFactor);
            }
            BaseBudItem.setThc(drop, thcVal);
            BaseBudItem.setCbd(drop, cbdVal);
        }
        for (ItemStack drop : drops) {
            Block.popResource((Level)serverLevel, (BlockPos)this.worldPosition, (ItemStack)drop);
        }
        this.cropAge = 0;
        this.growthProgressTicks = 0;
        this.setChangedAndSync();
    }

    public boolean removeCropAndGiveSeed(ServerLevel level, Player player) {
        if (!this.hasCrop()) {
            return false;
        }
        Item seedItem = this.cropBlock.getBaseSeedId().asItem();
        ItemStack seed = new ItemStack((ItemLike)seedItem);
        if (!player.addItem(seed)) {
            Block.popResource((Level)level, (BlockPos)this.worldPosition, (ItemStack)seed);
        }
        this.clearCrop();
        return true;
    }

    public boolean removeSoilAndGiveBack(ServerLevel level, Player player) {
        if (!this.hasSoil() || this.hasCrop()) {
            return false;
        }
        ItemStack soil = new ItemStack((ItemLike)this.soilState.getBlock());
        if (!player.addItem(soil)) {
            Block.popResource((Level)level, (BlockPos)this.worldPosition, (ItemStack)soil);
        }
        this.clearSoil();
        return true;
    }

    public void setChangedAndSync() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public Config.NutrientTarget getOptimalNutrientsLevels() {
        if (this.cropBlock == null) {
            return new Config.NutrientTarget(0, 0, 0);
        }
        ResourceLocation cropId = BuiltInRegistries.BLOCK.getKey((Object)this.cropBlock);
        return Config.getNutrientTargetFor(cropId).orElseGet(() -> new Config.NutrientTarget(0, 0, 0));
    }

    public int getThc() {
        return this.computeWithNutrients(this.thc);
    }

    public int getCbd() {
        return this.computeWithNutrients(this.cbd);
    }

    public int getBudCount() {
        if (this.cropBlock == null) {
            return 0;
        }
        ResourceLocation cropId = BuiltInRegistries.BLOCK.getKey((Object)this.cropBlock);
        Optional<Config.NutrientTarget> targetOpt = Config.getNutrientTargetFor(cropId);
        if (targetOpt.isEmpty()) {
            return 1;
        }
        Config.NutrientTarget t = targetOpt.get();
        int dn = Math.abs(this.nitrogen - t.n);
        int dp = Math.abs(this.phosphorus - t.p);
        int dk = Math.abs(this.potassium - t.k);
        if (dn == 0 && dp == 0 && dk == 0) {
            return 3;
        }
        int NPK_TOL = 3;
        int offCount = 0;
        if (dn > 3) {
            ++offCount;
        }
        if (dp > 3) {
            ++offCount;
        }
        if (dk > 3) {
            ++offCount;
        }
        return offCount == 0 ? 2 : 1;
    }

    private int computeWithNutrients(int base) {
        if (this.cropBlock == null) {
            return base;
        }
        ResourceLocation cropId = BuiltInRegistries.BLOCK.getKey((Object)this.cropBlock);
        Optional<Config.NutrientTarget> targetOpt = Config.getNutrientTargetFor(cropId);
        if (targetOpt.isEmpty()) {
            return base;
        }
        Config.NutrientTarget t = targetOpt.get();
        int dn = Math.abs(this.nitrogen - t.n);
        int dp = Math.abs(this.phosphorus - t.p);
        int dk = Math.abs(this.potassium - t.k);
        if (dn == 0 && dp == 0 && dk == 0) {
            return Mth.clamp((int)(base * 2), (int)0, (int)100);
        }
        int totalDiff = dn + dp + dk;
        int reduction = (int)Math.round((double)base * 0.1 * (double)totalDiff);
        int value = base - reduction;
        return Mth.clamp((int)value, (int)0, (int)100);
    }

    @Nullable
    public static BaseWeedCropBlock resolveCropBySeed(Item seed) {
        for (Block b : BuiltInRegistries.BLOCK) {
            BaseWeedCropBlock crop;
            if (!(b instanceof BaseWeedCropBlock) || (crop = (BaseWeedCropBlock)b).getBaseSeedId().asItem() != seed) continue;
            return crop;
        }
        return null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        Optional<ResourceLocation> soilId = this.soilState != null ? Optional.ofNullable(BuiltInRegistries.BLOCK.getKey((Object)this.soilState.getBlock())) : Optional.empty();
        Optional<ResourceLocation> cropId = this.cropBlock != null ? Optional.ofNullable(BuiltInRegistries.BLOCK.getKey((Object)this.cropBlock)) : Optional.empty();
        PotData data = new PotData(soilId, cropId, this.cropAge, this.growthProgressTicks, this.thc, this.cbd, this.ph, this.nitrogen, this.phosphorus, this.potassium);
        PotData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)data).resultOrPartial(err -> {}).ifPresent(encoded -> tag.put("Pot", encoded));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.soilState = null;
        this.cropBlock = null;
        this.cropAge = 0;
        this.growthProgressTicks = 0;
        this.potassium = 0;
        this.phosphorus = 0;
        this.nitrogen = 0;
        this.ph = 0;
        this.cbd = 0;
        this.thc = 0;
        if (tag.contains("Pot")) {
            PotData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("Pot")).result().ifPresent(data -> {
                data.soil().ifPresent(rl -> {
                    Block b = (Block)BuiltInRegistries.BLOCK.get(rl);
                    if (b != null) {
                        this.soilState = b.defaultBlockState();
                    }
                });
                data.crop().ifPresent(rl -> {
                    Block b = (Block)BuiltInRegistries.BLOCK.get(rl);
                    if (b instanceof BaseWeedCropBlock) {
                        BaseWeedCropBlock crop;
                        this.cropBlock = crop = (BaseWeedCropBlock)b;
                    }
                });
                this.cropAge = Math.max(0, data.age());
                this.growthProgressTicks = Math.max(0, data.prog());
                this.thc = Math.max(0, data.thc());
                this.cbd = Math.max(0, data.cbd());
                this.ph = Math.max(0, data.ph());
                this.nitrogen = Math.max(0, data.n());
                this.phosphorus = Math.max(0, data.p());
                this.potassium = Math.max(0, data.k());
            });
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    private record PotData(Optional<ResourceLocation> soil, Optional<ResourceLocation> crop, int age, int prog, int thc, int cbd, int ph, int n, int p, int k) {
        static final Codec<PotData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.optionalFieldOf("soil").forGetter(PotData::soil), (App)ResourceLocation.CODEC.optionalFieldOf("crop").forGetter(PotData::crop), (App)Codec.INT.fieldOf("age").forGetter(PotData::age), (App)Codec.INT.fieldOf("prog").forGetter(PotData::prog), (App)Codec.INT.fieldOf("thc").forGetter(PotData::thc), (App)Codec.INT.fieldOf("cbd").forGetter(PotData::cbd), (App)Codec.INT.fieldOf("ph").forGetter(PotData::ph), (App)Codec.INT.fieldOf("n").forGetter(PotData::n), (App)Codec.INT.fieldOf("p").forGetter(PotData::p), (App)Codec.INT.fieldOf("k").forGetter(PotData::k)).apply((Applicative)inst, PotData::new));
    }
}

