/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.recipe.LiquifierRecipe;
import net.micaxs.smokeleaf.recipe.LiquifierRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.screen.custom.LiquifierMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquifierBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int INPUT_SLOT = 0;
    public final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            LiquifierBlockEntity.this.setChanged();
            if (!LiquifierBlockEntity.this.level.isClientSide()) {
                LiquifierBlockEntity.this.level.sendBlockUpdated(LiquifierBlockEntity.this.getBlockPos(), LiquifierBlockEntity.this.getBlockState(), LiquifierBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && LiquifierBlockEntity.this.isValidInput(stack);
        }
    };
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(64000, 320){

        @Override
        public void onEnergyChanged() {
            LiquifierBlockEntity.this.setChanged();
            LiquifierBlockEntity.this.getLevel().sendBlockUpdated(LiquifierBlockEntity.this.getBlockPos(), LiquifierBlockEntity.this.getBlockState(), LiquifierBlockEntity.this.getBlockState(), 1);
        }
    };
    private final FluidTank FLUID_TANK = new FluidTank(8000){

        protected void onContentsChanged() {
            LiquifierBlockEntity.this.setChanged();
            if (!LiquifierBlockEntity.this.level.isClientSide()) {
                LiquifierBlockEntity.this.level.sendBlockUpdated(LiquifierBlockEntity.this.getBlockPos(), LiquifierBlockEntity.this.getBlockState(), LiquifierBlockEntity.this.getBlockState(), 3);
            }
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return true;
        }
    };
    protected final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> LiquifierBlockEntity.this.progress;
                case 1 -> LiquifierBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    LiquifierBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    LiquifierBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 156;

    private boolean isValidInput(ItemStack stack) {
        if (this.level == null || stack.isEmpty()) {
            return false;
        }
        LiquifierRecipeInput input = new LiquifierRecipeInput(stack);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.LIQUIFIER_TYPE.get(), (RecipeInput)input, this.level).isPresent();
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.itemHandler;
    }

    public LiquifierBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.LIQUIFIER_BE.get(), pos, blockState);
    }

    public ItemStack getRenderStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public FluidStack getFluid() {
        return this.FLUID_TANK.getFluid();
    }

    public IFluidHandler getTank(@Nullable Direction direction) {
        return this.FLUID_TANK;
    }

    private Optional<LiquifierRecipe> getCurrentRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.LIQUIFIER_TYPE.get(), (RecipeInput)new LiquifierRecipeInput(stack), this.level).map(RecipeHolder::value);
    }

    private boolean hasSpaceFor(LiquifierRecipe recipe) {
        FluidStack out = recipe.output();
        if (out.isEmpty()) {
            return false;
        }
        if (this.FLUID_TANK.isEmpty()) {
            return out.getAmount() <= this.FLUID_TANK.getCapacity();
        }
        if (!this.FLUID_TANK.getFluid().is(out.getFluid())) {
            return false;
        }
        return this.FLUID_TANK.getFluidAmount() + out.getAmount() <= this.FLUID_TANK.getCapacity();
    }

    private void craftFluid(LiquifierRecipe recipe) {
        this.itemHandler.extractItem(0, 1, false);
        this.FLUID_TANK.fill(recipe.outputCopy(), IFluidHandler.FluidAction.EXECUTE);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        boolean shouldBePowered;
        boolean hasEnergy = this.ENERGY_STORAGE.getEnergyStored() > 0;
        Optional<LiquifierRecipe> recipeOpt = this.getCurrentRecipe();
        if (hasEnergy && recipeOpt.isPresent() && this.hasSpaceFor(recipeOpt.get())) {
            ++this.progress;
            this.ENERGY_STORAGE.extractEnergy(20, false);
            if (level.random.nextInt(2) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
            if (this.progress >= this.maxProgress) {
                this.craftFluid(recipeOpt.get());
                this.progress = 0;
            }
            LiquifierBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        } else if (this.progress != 0) {
            this.progress = 0;
            LiquifierBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
        boolean bl = shouldBePowered = this.progress > 0 || hasEnergy && recipeOpt.isPresent();
        if ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) != shouldBePowered) {
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)));
        }
    }

    private void pushFluidToAboveNeighbour() {
        FluidUtil.getFluidHandler((Level)this.level, (BlockPos)this.worldPosition.above(), null).ifPresent(handler -> FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.FLUID_TANK, (int)Integer.MAX_VALUE, (boolean)true));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Weed Liquifier");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inv, Player player) {
        return new LiquifierMenu(i, inv, this, this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        inventory.setItem(0, this.itemHandler.getStackInSlot(0));
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        tag.put("liquifier.inventory", (Tag)this.itemHandler.serializeNBT(regs));
        tag.putInt("liquifier.progress", this.progress);
        tag.putInt("liquifier.maxProgress", this.maxProgress);
        tag.putInt("liquifier.energy", this.ENERGY_STORAGE.getEnergyStored());
        tag = this.FLUID_TANK.writeToNBT(regs, tag);
        super.saveAdditional(tag, regs);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        this.itemHandler.deserializeNBT(regs, tag.getCompound("liquifier.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("liquifier.energy"));
        this.progress = tag.getInt("liquifier.progress");
        this.maxProgress = tag.getInt("liquifier.maxProgress");
        this.FLUID_TANK.readFromNBT(regs, tag);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider regs) {
        return this.saveWithoutMetadata(regs);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
    }
}

