/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.ArrayList;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.custom.ReflectorBlock;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectorBlockEntity
extends BlockEntity {
    private static final int GROW_RADIUS = 1;
    private static final int GROW_DEPTH = 5;
    private static final int GROW_TICK_INTERVAL = 100;
    private static final int ATTEMPTS_PER_CYCLE = 1;
    private ItemStack lamp = ItemStack.EMPTY;
    private int tickCounter = 0;

    public ReflectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REFLECTOR.get(), pos, state);
    }

    public void setLamp(ItemStack stack) {
        BlockState st;
        this.lamp = stack.copy();
        this.setChanged();
        if (this.level != null && !this.level.isClientSide && !((Boolean)(st = this.getBlockState()).getValue((Property)ReflectorBlock.HAS_LAMP)).booleanValue()) {
            this.level.setBlock(this.worldPosition, (BlockState)st.setValue((Property)ReflectorBlock.HAS_LAMP, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public ItemStack getLampStack() {
        return this.lamp;
    }

    public ItemStack getLamp() {
        return this.lamp;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ReflectorBlockEntity be) {
        if (be.lamp.isEmpty()) {
            return;
        }
        if (be.lamp.isDamageableItem()) {
            int newDamage = be.lamp.getDamageValue() + 1;
            be.lamp.setDamageValue(newDamage);
            if (newDamage >= be.lamp.getMaxDamage()) {
                if (!level.isClientSide) {
                    level.playSound(null, pos, ModSounds.LAMP_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                be.lamp = ItemStack.EMPTY;
                if (((Boolean)state.getValue((Property)ReflectorBlock.HAS_LAMP)).booleanValue()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ReflectorBlock.HAS_LAMP, (Comparable)Boolean.valueOf(false)), 3);
                }
                be.setChanged();
                return;
            }
            be.setChanged();
        }
        ++be.tickCounter;
        if (be.tickCounter < 100) {
            return;
        }
        be.tickCounter = 0;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ReflectorBlockEntity.accelerateCrops(serverLevel, pos);
        }
    }

    public int getLampRemainingTicks() {
        if (this.lamp == null || this.lamp.isEmpty()) {
            return 0;
        }
        int max = this.lamp.getMaxDamage();
        int dmg = this.lamp.getDamageValue();
        int remaining = Math.max(0, max - dmg);
        return remaining;
    }

    public ItemStack extractLamp() {
        BlockState st;
        if (this.lamp.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack out = this.lamp.copy();
        this.lamp = ItemStack.EMPTY;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide && ((Boolean)(st = this.getBlockState()).getValue((Property)ReflectorBlock.HAS_LAMP)).booleanValue()) {
            this.level.setBlock(this.worldPosition, (BlockState)st.setValue((Property)ReflectorBlock.HAS_LAMP, (Comparable)Boolean.valueOf(false)), 3);
        }
        return out;
    }

    private static void accelerateCrops(ServerLevel level, BlockPos origin) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int depth = 1; depth <= 5; ++depth) {
                    BaseWeedCropBlock crop;
                    cursor.set(origin.getX() + dx, origin.getY() - depth, origin.getZ() + dz);
                    BlockState cropState = level.getBlockState((BlockPos)cursor);
                    Block block = cropState.getBlock();
                    if (!(block instanceof BaseWeedCropBlock) || ((Boolean)cropState.getValue((Property)(crop = (BaseWeedCropBlock)block).getTop())).booleanValue() || crop.isMaxAge(cropState) || !ReflectorBlockEntity.hasVerticalLineOfSight((Level)level, origin, (BlockPos)cursor)) continue;
                    candidates.add(cursor.immutable());
                }
            }
        }
        if (candidates.isEmpty()) {
            return;
        }
        RandomSource rand = level.random;
        int attempts = Math.min(1, candidates.size());
        for (int i = 0; i < attempts; ++i) {
            BaseWeedCropBlock crop;
            float f;
            int bound;
            BlockPos targetPos = (BlockPos)candidates.get(rand.nextInt(candidates.size()));
            BlockState st = level.getBlockState(targetPos);
            Block block = st.getBlock();
            if (!(block instanceof BaseWeedCropBlock) || rand.nextInt(bound = (int)(25.0f / (f = (crop = (BaseWeedCropBlock)block).getLocalGrowthSpeed((BlockGetter)level, targetPos))) + 1) != 0) continue;
            ReflectorBlockEntity.growOneStageTall(level, targetPos, st, crop);
        }
    }

    private static boolean hasVerticalLineOfSight(Level level, BlockPos from, BlockPos to) {
        int topY;
        for (int y = topY = from.getY() - 1; y > to.getY(); --y) {
            BlockPos mid = new BlockPos(to.getX(), y, to.getZ());
            BlockState bs = level.getBlockState(mid);
            if (!bs.canOcclude()) continue;
            return false;
        }
        return true;
    }

    private static void growOneStageTall(ServerLevel level, BlockPos bottomPos, BlockState bottomState, BaseWeedCropBlock crop) {
        int max;
        IntegerProperty ageProp = crop.getAgeProperty();
        BooleanProperty topProp = crop.getTop();
        int age = (Integer)bottomState.getValue((Property)ageProp);
        if (age >= (max = crop.getMaxAge())) {
            return;
        }
        int newAge = Math.min(age + 1, max);
        BlockState newBottom = (BlockState)bottomState.setValue((Property)ageProp, (Comparable)Integer.valueOf(newAge));
        level.setBlock(bottomPos, newBottom, 2);
        int tallAge = crop.getTallAge();
        BlockPos topPos = bottomPos.above();
        if (newAge >= tallAge) {
            BlockState topState = level.getBlockState(topPos);
            if (topState.getBlock() == crop) {
                level.setBlock(topPos, (BlockState)((BlockState)topState.setValue((Property)ageProp, (Comparable)Integer.valueOf(newAge))).setValue((Property)topProp, (Comparable)Boolean.valueOf(true)), 2);
            } else if (topState.isAir()) {
                BlockState createdTop = (BlockState)newBottom.setValue((Property)topProp, (Comparable)Boolean.valueOf(true));
                level.setBlock(topPos, createdTop, 2);
            }
        }
    }

    public void dropContents() {
        if (!this.lamp.isEmpty() && this.level != null) {
            Containers.dropItemStack((Level)this.level, (double)((double)this.worldPosition.getX() + 0.5), (double)((double)this.worldPosition.getY() + 0.5), (double)((double)this.worldPosition.getZ() + 0.5), (ItemStack)this.lamp);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide) {
            boolean hasLamp;
            BlockState st = this.getBlockState();
            boolean bl = hasLamp = !this.lamp.isEmpty();
            if ((Boolean)st.getValue((Property)ReflectorBlock.HAS_LAMP) != hasLamp) {
                this.level.setBlock(this.worldPosition, (BlockState)st.setValue((Property)ReflectorBlock.HAS_LAMP, (Comparable)Boolean.valueOf(hasLamp)), 2);
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.lamp.isEmpty()) {
            tag.put("Lamp", this.lamp.save(provider));
        }
        tag.putInt("TickCounter", this.tickCounter);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.lamp = tag.contains("Lamp") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("Lamp")) : ItemStack.EMPTY;
        this.tickCounter = tag.getInt("TickCounter");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

