/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.block.entity;

import java.util.Optional;
import net.micaxs.smokeleaf.block.entity.ModBlockEntities;
import net.micaxs.smokeleaf.block.entity.energy.ModEnergyStorage;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.item.custom.DNAStrandItem;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.SynthesizerRecipe;
import net.micaxs.smokeleaf.recipe.SynthesizerRecipeInput;
import net.micaxs.smokeleaf.screen.custom.SynthesizerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynthesizerBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int DNA_SLOT = 0;
    private static final int REAGENT_SLOT_1 = 1;
    private static final int REAGENT_SLOT_2 = 2;
    private static final int REAGENT_SLOT_3 = 3;
    private static final int OUTPUT_SLOT = 4;
    private static final int ENERGY_TRANSFER_AMOUNT = 320;
    private int progress = 0;
    private int maxProgress = 82;
    protected final ContainerData data;
    public final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            SynthesizerBlockEntity.this.setChanged();
            if (!SynthesizerBlockEntity.this.level.isClientSide()) {
                SynthesizerBlockEntity.this.level.sendBlockUpdated(SynthesizerBlockEntity.this.getBlockPos(), SynthesizerBlockEntity.this.getBlockState(), SynthesizerBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.is(ModItems.DNA_STRAND);
                case 1, 2, 3 -> {
                    if (!stack.is(ModItems.DNA_STRAND)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> false;
                default -> false;
            };
        }
    };
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(64000, 320){

        @Override
        public void onEnergyChanged() {
            SynthesizerBlockEntity.this.setChanged();
            SynthesizerBlockEntity.this.getLevel().sendBlockUpdated(SynthesizerBlockEntity.this.getBlockPos(), SynthesizerBlockEntity.this.getBlockState(), SynthesizerBlockEntity.this.getBlockState(), 1);
        }
    };

    public SynthesizerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SYNTHESIZER_BE.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> SynthesizerBlockEntity.this.progress;
                    case 1 -> SynthesizerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        SynthesizerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        SynthesizerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.literal((String)"DNA Synthesizer");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new SynthesizerMenu(id, inv, this, this.data);
    }

    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction dir) {
        return this.ENERGY_STORAGE;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean powered;
        boolean hasEnergy;
        boolean bl = hasEnergy = this.ENERGY_STORAGE.getEnergyStored() > 0;
        if (hasEnergy && this.hasRecipe()) {
            ++this.progress;
            this.ENERGY_STORAGE.extractEnergy(20, false);
            if (level.random.nextInt(2) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
            if (this.progress >= this.maxProgress) {
                this.craftItem();
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
        SynthesizerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        boolean bl2 = powered = this.progress > 0 || hasEnergy && this.hasRecipe();
        if ((Boolean)state.getValue((Property)BlockStateProperties.POWERED) != powered) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    private Optional<RecipeHolder<SynthesizerRecipe>> getCurrentRecipe() {
        SynthesizerRecipeInput input = new SynthesizerRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2), this.itemHandler.getStackInSlot(3));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.SYNTHESIZER_TYPE.get(), (RecipeInput)input, this.level);
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<SynthesizerRecipe>> opt = this.getCurrentRecipe();
        if (opt.isEmpty()) {
            return false;
        }
        ItemStack dna = this.itemHandler.getStackInSlot(0);
        if (!(dna.getItem() instanceof DNAStrandItem)) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(1).isEmpty()) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(2).isEmpty()) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(3).isEmpty()) {
            return false;
        }
        ItemStack simulated = ((SynthesizerRecipe)opt.get().value()).assemble(new SynthesizerRecipeInput(dna, this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2), this.itemHandler.getStackInSlot(3)), (HolderLookup.Provider)this.level.registryAccess());
        return this.canInsertItemIntoOutputSlot(simulated) && this.canInsertAmountIntoOutputSlot(simulated.getCount());
    }

    private void craftItem() {
        ItemStack existing;
        SynthesizerRecipeInput input;
        Optional<RecipeHolder<SynthesizerRecipe>> opt = this.getCurrentRecipe();
        if (opt.isEmpty()) {
            return;
        }
        SynthesizerRecipe recipe = (SynthesizerRecipe)opt.get().value();
        ItemStack output = recipe.assemble(input = new SynthesizerRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2), this.itemHandler.getStackInSlot(3)), (HolderLookup.Provider)this.level.registryAccess());
        if (output.isEmpty()) {
            return;
        }
        this.itemHandler.extractItem(0, 1, false);
        if (!this.itemHandler.getStackInSlot(1).isEmpty()) {
            this.itemHandler.extractItem(1, 1, false);
        }
        if (!this.itemHandler.getStackInSlot(2).isEmpty()) {
            this.itemHandler.extractItem(2, 1, false);
        }
        if (!this.itemHandler.getStackInSlot(3).isEmpty()) {
            this.itemHandler.extractItem(3, 1, false);
        }
        if ((existing = this.itemHandler.getStackInSlot(4)).isEmpty()) {
            this.itemHandler.setStackInSlot(4, output);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)output)) {
            existing.grow(output.getCount());
        }
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack stack) {
        ItemStack existing = this.itemHandler.getStackInSlot(4);
        return existing.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        ItemStack existing = this.itemHandler.getStackInSlot(4);
        if (existing.isEmpty()) {
            return count <= 64;
        }
        return existing.getCount() + count <= existing.getMaxStackSize();
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("synthesizer.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("synthesizer.progress", this.progress);
        tag.putInt("synthesizer.maxProgress", this.maxProgress);
        tag.putInt("synthesizer.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("synthesizer.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("synthesizer.energy"));
        this.progress = tag.getInt("synthesizer.progress");
        this.maxProgress = tag.getInt("synthesizer.maxProgress");
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookup) {
        super.onDataPacket(net, pkt, lookup);
    }
}

