/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jade;

import net.micaxs.smokeleaf.Config;
import net.micaxs.smokeleaf.block.entity.GrowPotBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum GrowPotProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        ResourceLocation cropId;
        BlockState cropState;
        ResourceLocation soilId;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof GrowPotBlockEntity)) {
            return;
        }
        GrowPotBlockEntity pot = (GrowPotBlockEntity)blockEntity;
        tag.putInt("n", pot.getNitrogen());
        tag.putInt("p", pot.getPhosphorus());
        tag.putInt("k", pot.getPotassium());
        Config.NutrientTarget target = pot.getOptimalNutrientsLevels();
        tag.putInt("tn", target.n);
        tag.putInt("tp", target.p);
        tag.putInt("tk", target.k);
        BlockState soil = pot.getSoilState();
        if (soil != null && (soilId = BuiltInRegistries.BLOCK.getKey((Object)soil.getBlock())) != null) {
            tag.putString("soil", soilId.toString());
        }
        if ((cropState = pot.getBottomCropStateForRender()) != null && (cropId = BuiltInRegistries.BLOCK.getKey((Object)cropState.getBlock())) != null) {
            tag.putString("crop", cropId.toString());
        }
        int age = pot.getCropAge();
        int maxAge = pot.getCropMaxAge();
        tag.putInt("age", age);
        tag.putInt("maxAge", maxAge);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.contains("soil")) {
            ResourceLocation soilId = ResourceLocation.tryParse((String)data.getString("soil"));
            Block soilBlock = soilId != null ? (Block)BuiltInRegistries.BLOCK.get(soilId) : null;
            MutableComponent soilName = soilBlock != null ? Component.translatable((String)soilBlock.getDescriptionId()) : Component.literal((String)"Unknown");
            tooltip.add((Component)Component.literal((String)"Soil: ").append((Component)soilName));
        } else {
            tooltip.add((Component)Component.literal((String)"Soil: Empty"));
        }
        if (data.contains("crop")) {
            ResourceLocation cropId = ResourceLocation.tryParse((String)data.getString("crop"));
            Block cropBlock = cropId != null ? (Block)BuiltInRegistries.BLOCK.get(cropId) : null;
            MutableComponent cropName = cropBlock != null ? Component.translatable((String)cropBlock.getDescriptionId()) : Component.literal((String)"Unknown");
            tooltip.add((Component)Component.literal((String)"Crop: ").append((Component)cropName));
        } else {
            tooltip.add((Component)Component.literal((String)"Crop: None"));
        }
        if (data.contains("age") && data.contains("maxAge")) {
            int age = data.getInt("age");
            int maxAge = data.getInt("maxAge");
            if (maxAge > 0) {
                if (age >= maxAge) {
                    tooltip.add((Component)Component.literal((String)"Growth: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"Mature").withStyle(ChatFormatting.GREEN)));
                } else if (age < maxAge / 2) {
                    int pct = Math.max(0, Math.min(100, (int)Math.round((double)age * 100.0 / (double)maxAge)));
                    tooltip.add((Component)Component.literal((String)"Growth: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(pct + "%")).withStyle(ChatFormatting.WHITE)));
                } else {
                    int pct = Math.max(0, Math.min(100, (int)Math.round((double)age * 100.0 / (double)maxAge)));
                    tooltip.add((Component)Component.literal((String)"Growth: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(pct + "%")).withStyle(ChatFormatting.YELLOW)));
                }
            } else {
                tooltip.add((Component)Component.literal((String)"Growth: None").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (GrowPotProvider.hasAll(data, "n", "p", "k", "tn", "tp", "tk")) {
            int n = data.getInt("n");
            int p = data.getInt("p");
            int k = data.getInt("k");
            int tn = data.getInt("tn");
            int tp = data.getInt("tp");
            int tk = data.getInt("tk");
            if (tn == 0 && tp == 0 && tk == 0) {
                return;
            }
            tooltip.add((Component)Component.literal((String)"Nitrogen (N): ").append((Component)Component.literal((String)String.valueOf(n)).withStyle(GrowPotProvider.colorForDiff(Math.abs(n - tn)))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(tn)).withStyle(ChatFormatting.GREEN)));
            tooltip.add((Component)Component.literal((String)"Phosphorus (P): ").append((Component)Component.literal((String)String.valueOf(p)).withStyle(GrowPotProvider.colorForDiff(Math.abs(p - tp)))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(tp)).withStyle(ChatFormatting.GREEN)));
            tooltip.add((Component)Component.literal((String)"Potassium (K): ").append((Component)Component.literal((String)String.valueOf(k)).withStyle(GrowPotProvider.colorForDiff(Math.abs(k - tk)))).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.valueOf(tk)).withStyle(ChatFormatting.GREEN)));
        }
    }

    private static boolean hasAll(CompoundTag t, String ... keys) {
        for (String k : keys) {
            if (t.contains(k)) continue;
            return false;
        }
        return true;
    }

    private static ChatFormatting colorForDiff(int diff) {
        if (diff == 0) {
            return ChatFormatting.GREEN;
        }
        if (diff == 1) {
            return ChatFormatting.GOLD;
        }
        if (diff == 2) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.DARK_RED;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"grow_pot_jade");
    }
}

