/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.recipe.GeneratorRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GeneratorRecipeCategory
implements IRecipeCategory<GeneratorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"generator");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"textures/gui/jei_bg.png");
    public static final RecipeType<GeneratorRecipe> GENERATOR_RECIPE_TYPE = new RecipeType(UID, GeneratorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public GeneratorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 5, 5, 120, 46);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.GENERATOR.get()));
    }

    public RecipeType<GeneratorRecipe> getRecipeType() {
        return GENERATOR_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.smokeleafindustries.generator");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 46;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GeneratorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 14, 14).addIngredients((Ingredient)recipe.getIngredients().getFirst());
    }

    public void draw(GeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        int total = recipe.totalEnergy();
        int ticks = recipe.computedBurnTime();
        String energyLine = total + " FE";
        String ticksLine = ticks + " ticks";
        guiGraphics.drawString(Minecraft.getInstance().font, energyLine, 40, 12, 16765823, false);
        guiGraphics.drawString(Minecraft.getInstance().font, ticksLine, 40, 24, 0xFFFFFF, false);
    }
}

