/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.component;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import java.util.function.UnaryOperator;
import net.micaxs.smokeleaf.component.DNAContents;
import net.micaxs.smokeleaf.component.ManualGrinderContents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModDataComponentTypes {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"smokeleafindustries");
    private static final Codec<JsonArray> JSON_ARRAY_CODEC = Codec.STRING.xmap(s -> {
        try {
            return JsonParser.parseString((String)s).getAsJsonArray();
        }
        catch (Exception e) {
            return new JsonArray();
        }
    }, JsonElement::toString);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> ACTIVE_INGREDIENT = ModDataComponentTypes.register("active_ingredient", builder -> builder.persistent((Codec)Codec.STRING));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<JsonArray>> ACTIVE_INGREDIENTS = ModDataComponentTypes.register("active_ingredients", builder -> builder.persistent(JSON_ARRAY_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> EFFECT_DURATION = ModDataComponentTypes.register("effect_duration", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> DRY = ModDataComponentTypes.register("dry", builder -> builder.persistent((Codec)Codec.BOOL));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> DRYING_TIME = ModDataComponentTypes.register("drying_time", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> THC = ModDataComponentTypes.register("thc", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> CBD = ModDataComponentTypes.register("cbd", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> PH = ModDataComponentTypes.register("ph", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> NITROGEN = ModDataComponentTypes.register("nitrogen", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> PHOSPHORUS = ModDataComponentTypes.register("phosphorus", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> POTASSIUM = ModDataComponentTypes.register("potassium", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<DNAContents>> DNA_CONTENTS = ModDataComponentTypes.register("dna_contents", b -> b.persistent(DNAContents.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ManualGrinderContents>> MANUAL_GRINDER_CONTENTS = ModDataComponentTypes.register("manual_grinder_contents", b -> b.persistent(ManualGrinderContents.CODEC));

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENT_TYPES.register(eventBus);
    }
}

