/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.datagen;

import java.util.function.Function;
import net.micaxs.smokeleaf.block.ModBlocks;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.custom.GrowLightBlock;
import net.micaxs.smokeleaf.block.custom.ReflectorBlock;
import net.micaxs.smokeleaf.block.custom.TobaccoCropBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "smokeleafindustries", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.HEMP_STONE);
        this.stairsBlock((StairBlock)ModBlocks.HEMP_STONE_STAIRS.get(), this.blockTexture((Block)ModBlocks.HEMP_STONE.get()));
        this.slabBlock((SlabBlock)ModBlocks.HEMP_STONE_SLAB.get(), this.blockTexture((Block)ModBlocks.HEMP_STONE.get()), this.blockTexture((Block)ModBlocks.HEMP_STONE.get()));
        this.blockItem(ModBlocks.HEMP_STONE_SLAB);
        this.blockItem(ModBlocks.HEMP_STONE_STAIRS);
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.HEMP_STONE_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.HEMP_STONE.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.HEMP_STONE_BUTTON.get(), this.blockTexture((Block)ModBlocks.HEMP_STONE.get()));
        this.blockItem(ModBlocks.HEMP_STONE_PRESSURE_PLATE);
        this.wallBlock((WallBlock)ModBlocks.HEMP_STONE_WALL.get(), this.blockTexture((Block)ModBlocks.HEMP_STONE.get()));
        this.blockWithItem(ModBlocks.HEMP_BRICKS);
        this.stairsBlock((StairBlock)ModBlocks.HEMP_BRICK_STAIRS.get(), this.blockTexture((Block)ModBlocks.HEMP_BRICKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.HEMP_BRICK_SLAB.get(), this.blockTexture((Block)ModBlocks.HEMP_BRICKS.get()), this.blockTexture((Block)ModBlocks.HEMP_BRICKS.get()));
        this.blockItem(ModBlocks.HEMP_BRICK_SLAB);
        this.blockItem(ModBlocks.HEMP_BRICK_STAIRS);
        this.wallBlock((WallBlock)ModBlocks.HEMP_BRICK_WALL.get(), this.blockTexture((Block)ModBlocks.HEMP_BRICKS.get()));
        this.blockWithItem(ModBlocks.HEMP_CHISELED_STONE);
        this.stairsBlock((StairBlock)ModBlocks.HEMP_CHISELED_STONE_STAIRS.get(), this.blockTexture((Block)ModBlocks.HEMP_CHISELED_STONE.get()));
        this.slabBlock((SlabBlock)ModBlocks.HEMP_CHISELED_STONE_SLAB.get(), this.blockTexture((Block)ModBlocks.HEMP_CHISELED_STONE.get()), this.blockTexture((Block)ModBlocks.HEMP_CHISELED_STONE.get()));
        this.blockItem(ModBlocks.HEMP_CHISELED_STONE_SLAB);
        this.blockItem(ModBlocks.HEMP_CHISELED_STONE_STAIRS);
        this.wallBlock((WallBlock)ModBlocks.HEMP_CHISELED_STONE_WALL.get(), this.blockTexture((Block)ModBlocks.HEMP_CHISELED_STONE.get()));
        this.blockWithItem(ModBlocks.HEMP_PLANKS);
        this.stairsBlock((StairBlock)ModBlocks.HEMP_PLANK_STAIRS.get(), this.blockTexture((Block)ModBlocks.HEMP_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.HEMP_PLANK_SLAB.get(), this.blockTexture((Block)ModBlocks.HEMP_PLANKS.get()), this.blockTexture((Block)ModBlocks.HEMP_PLANKS.get()));
        this.blockItem(ModBlocks.HEMP_PLANK_SLAB);
        this.blockItem(ModBlocks.HEMP_PLANK_STAIRS);
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.HEMP_PLANK_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.HEMP_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.HEMP_PLANK_BUTTON.get(), this.blockTexture((Block)ModBlocks.HEMP_PLANKS.get()));
        this.blockItem(ModBlocks.HEMP_PLANK_PRESSURE_PLATE);
        this.fenceBlock((FenceBlock)ModBlocks.HEMP_PLANK_FENCE.get(), this.blockTexture((Block)ModBlocks.HEMP_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.HEMP_PLANK_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.HEMP_PLANKS.get()));
        this.blockItem(ModBlocks.HEMP_PLANK_FENCE_GATE);
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.HEMP_PLANK_DOOR.get(), this.modLoc("block/hemp_plank_door_bottom"), this.modLoc("block/hemp_plank_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.HEMP_PLANK_TRAPDOOR.get(), this.modLoc("block/hemp_plank_trapdoor"), true, "cutout");
        this.blockItem(ModBlocks.HEMP_PLANK_TRAPDOOR, "_bottom");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.HEMP_CROP.get()), "hemp_stage_", "hemp/hemp_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.WHITE_WIDOW_CROP.get()), "white_widow_stage_", "white_widow/white_widow_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.BUBBLE_KUSH_CROP.get()), "bubble_kush_stage_", "bubble_kush/bubble_kush_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.LEMON_HAZE_CROP.get()), "lemon_haze_stage_", "lemon_haze/lemon_haze_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.SOUR_DIESEL_CROP.get()), "sour_diesel_stage_", "sour_diesel/sour_diesel_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.BLUE_ICE_CROP.get()), "blue_ice_stage_", "blue_ice/blue_ice_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.BUBBLEGUM_CROP.get()), "bubblegum_stage_", "bubblegum/bubblegum_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.PURPLE_HAZE_CROP.get()), "purple_haze_stage_", "purple_haze/purple_haze_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.OG_KUSH_CROP.get()), "og_kush_stage_", "og_kush/og_kush_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.JACK_HERER_CROP.get()), "jack_herer_stage_", "jack_herer/jack_herer_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.GARY_PEYTON_CROP.get()), "gary_peyton_stage_", "gary_peyton/gary_peyton_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.AMNESIA_HAZE_CROP.get()), "amnesia_haze_stage_", "amnesia_haze/amnesia_haze_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.AK47_CROP.get()), "ak47_stage_", "ak47/ak47_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.GHOST_TRAIN_CROP.get()), "ghost_train_stage_", "ghost_train/ghost_train_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.GRAPE_APE_CROP.get()), "grape_ape_stage_", "grape_ape/grape_ape_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.COTTON_CANDY_CROP.get()), "cotton_candy_stage_", "cotton_candy/cotton_candy_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.BANANA_KUSH_CROP.get()), "banana_kush_stage_", "banana_kush/banana_kush_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.CARBON_FIBER_CROP.get()), "carbon_fiber_stage_", "carbon_fiber/carbon_fiber_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.BIRTHDAY_CAKE_CROP.get()), "birthday_cake_stage_", "birthday_cake/birthday_cake_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.BLUE_COOKIES_CROP.get()), "blue_cookies_stage_", "blue_cookies/blue_cookies_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.AFGHANI_CROP.get()), "afghani_stage_", "afghani/afghani_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.MOONBOW_CROP.get()), "moonbow_stage_", "moonbow/moonbow_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.LAVA_CAKE_CROP.get()), "lava_cake_stage_", "lava_cake/lava_cake_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.JELLY_RANCHER_CROP.get()), "jelly_rancher_stage_", "jelly_rancher/jelly_rancher_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.STRAWBERRY_SHORTCAKE_CROP.get()), "strawberry_shortcake_stage_", "strawberry_shortcake/strawberry_shortcake_stage_");
        this.makeWeedCrop((BaseWeedCropBlock)((Object)ModBlocks.PINK_KUSH_CROP.get()), "pink_kush_stage_", "pink_kush/pink_kush_stage_");
        this.makeTobaccoCrop((TobaccoCropBlock)((Object)ModBlocks.TOBACCO_CROP.get()), "tobacco_stage_", "tobacco/tobacco_stage_");
        this.growLightWithClicked();
        this.horizontalBooleanVariants((Block)ModBlocks.REFLECTOR.get(), ReflectorBlock.FACING, ReflectorBlock.HAS_LAMP, "_lamp", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.GENERATOR.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.GRINDER.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.EXTRACTOR.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.LIQUIFIER.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.MUTATOR.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.SYNTHESIZER.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.SEQUENCER.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBooleanVariants((Block)ModBlocks.DRYER.get(), BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.POWERED, "_on", "", false);
        this.horizontalBlock((Block)ModBlocks.DRYING_RACK.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/drying_rack")));
        this.horizontalBlock((Block)ModBlocks.GROW_POT.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/grow_pot")));
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void growLightWithClicked() {
        Block block = (Block)ModBlocks.LED_LIGHT.get();
        VariantBlockStateBuilder vb = this.getVariantBuilder(block);
        String baseName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        vb.forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)GrowLightBlock.FACING);
            boolean clicked = (Boolean)state.getValue((Property)GrowLightBlock.CLICKED);
            String suffix = clicked ? "_on" : "_off";
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + baseName + suffix));
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)facing.toYRot() % 360).build();
        });
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.modLoc("block/" + baseName + "_off")));
    }

    private void makeTobaccoCrop(TobaccoCropBlock cropBlock, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.tobaccoCropModel((BlockState)state, cropBlock, modelName, textureName);
        this.getVariantBuilder((Block)cropBlock).forAllStates(function);
    }

    private void makeWeedCrop(BaseWeedCropBlock cropBlock, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = blockState -> {
            String textureFile;
            String modelFile;
            int age = (Integer)blockState.getValue((Property)cropBlock.getAgeProperty());
            boolean isTop = (Boolean)blockState.getValue((Property)cropBlock.getTop());
            if (isTop) {
                modelFile = modelName + age;
                textureFile = textureName + age;
            } else if (age <= 6) {
                modelFile = modelName + age;
                textureFile = textureName + age;
            } else if (age <= 8) {
                modelFile = modelName + "6";
                textureFile = textureName + "6";
            } else {
                modelFile = modelName + "6_full";
                textureFile = textureName + "6_full";
            }
            ResourceLocation tex = ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)("block/" + textureFile));
            ConfiguredModel cm = new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(modelFile, tex)).renderType("cutout"));
            return new ConfiguredModel[]{cm};
        };
        this.getVariantBuilder((Block)cropBlock).forAllStates(function);
    }

    private ConfiguredModel[] tobaccoCropModel(BlockState blockState, TobaccoCropBlock cropBlock, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(modelName + String.valueOf(blockState.getValue((Property)cropBlock.getAgeProperty())), ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)("block/" + textureName + String.valueOf(blockState.getValue((Property)cropBlock.getAgeProperty())))))).renderType("cutout"))};
        return models;
    }

    private ConfiguredModel[] weedCropModel(BlockState blockState, BaseWeedCropBlock cropBlock, String modelName, String textureName) {
        int age = (Integer)blockState.getValue((Property)cropBlock.getAgeProperty());
        boolean isTop = (Boolean)blockState.getValue((Property)cropBlock.getTop());
        String model = !isTop && (age == 9 || age == 10) ? modelName + "6_full" : modelName + age;
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(model, ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)("block/" + textureName + String.valueOf((age == 9 || age == 10) && !isTop ? "6_full" : Integer.valueOf(age)))))).renderType("cutout"))};
        return models;
    }

    private void horizontalBooleanVariants(Block block, DirectionProperty facingProp, BooleanProperty flagProp, String trueSuffix, String falseSuffix, boolean itemUsesTrueVariant) {
        VariantBlockStateBuilder vb = this.getVariantBuilder(block);
        String baseName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        vb.forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)facingProp);
            boolean flag = (Boolean)state.getValue((Property)flagProp);
            String suffix = flag ? trueSuffix : falseSuffix;
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + baseName + suffix));
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)facing.toYRot() % 360).build();
        });
        String itemSuffix = itemUsesTrueVariant ? trueSuffix : falseSuffix;
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.modLoc("block/" + baseName + itemSuffix)));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("smokeleafindustries:block/" + deferredBlock.getId().getPath()));
    }

    private void blockItem(DeferredBlock<Block> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("smokeleafindustries:block/" + deferredBlock.getId().getPath() + appendix));
    }
}

