/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.effect.neutral;

import net.micaxs.smokeleaf.network.GigglyFitPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class GigglyFitEffect
extends MobEffect {
    private static final int MIN_DELAY_TICKS = 15;
    private static final int MAX_DELAY_TICKS = 25;

    public GigglyFitEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CompoundTag data = entity.getPersistentData();
            long nextJumpTime = data.getLong("GigglyFitNextJump");
            long worldTime = entity.level().getGameTime();
            if (worldTime >= nextJumpTime) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new GigglyFitPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                RandomSource rand = entity.getRandom();
                long delay = 15 + rand.nextInt(11);
                data.putLong("GigglyFitNextJump", worldTime + delay);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public static void performJumpClient() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (player.onGround()) {
            player.jumpFromGround();
            player.playSound(SoundEvents.SLIME_JUMP, 1.0f, 1.0f);
            for (int i = 0; i < 6; ++i) {
                double offsetX = (Math.random() - 0.5) * 0.5;
                double offsetY = 0.1 + Math.random() * 0.3;
                double offsetZ = (Math.random() - 0.5) * 0.5;
                player.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, player.getX() + offsetX, player.getY() + 0.1, player.getZ() + offsetZ, 0.0, offsetY, 0.0);
            }
        }
    }
}

