/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import com.google.gson.JsonArray;
import java.util.List;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.utils.WeedEffectHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class HashOilTinctureItem
extends Item {
    public HashOilTinctureItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        JsonArray activeIngredients = (JsonArray)stack.get(ModDataComponentTypes.ACTIVE_INGREDIENTS);
        if (activeIngredients == null || activeIngredients.isEmpty()) {
            return;
        }
        List<BaseWeedItem> weedItems = WeedEffectHelper.jsonArrayToWeedList(activeIngredients);
        if (!weedItems.isEmpty()) {
            tooltipComponents.add((Component)Component.empty().append(WeedEffectHelper.getEffectTooltip(weedItems, true)));
        }
    }
}

