/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.micaxs.smokeleaf.block.entity.BaseWeedCropBlockEntity;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.loot.ModLootItemFunctions;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyBudStats
extends LootItemConditionalFunction {
    public static final MapCodec<ApplyBudStats> CODEC = RecordCodecBuilder.mapCodec(instance -> LootItemConditionalFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ApplyBudStats::new));

    protected ApplyBudStats(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public static LootItemConditionalFunction.Builder<?> apply() {
        return ApplyBudStats.simpleBuilder(ApplyBudStats::new);
    }

    public LootItemFunctionType<ApplyBudStats> getType() {
        return (LootItemFunctionType)ModLootItemFunctions.APPLY_BUD_STATS.get();
    }

    protected ItemStack run(ItemStack stack, LootContext ctx) {
        BlockEntity be = (BlockEntity)ctx.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (be instanceof BaseWeedCropBlockEntity) {
            BaseWeedCropBlockEntity crop = (BaseWeedCropBlockEntity)be;
            int buds = Mth.clamp((int)crop.getBudCount(), (int)1, (int)3);
            stack.setCount(buds);
            stack.set((DataComponentType)ModDataComponentTypes.THC.get(), (Object)crop.getThc());
            stack.set((DataComponentType)ModDataComponentTypes.CBD.get(), (Object)crop.getCbd());
        }
        return stack;
    }
}

