/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.micaxs.smokeleaf.item.custom.BluntItem;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.utils.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BluntRecipe
extends CustomRecipe {
    private final Item bluntResult;

    public BluntRecipe(CraftingBookCategory category, Item bluntResult) {
        super(category);
        this.bluntResult = bluntResult;
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.hasPattern(input);
    }

    private boolean hasPattern(CraftingInput input) {
        if (input.width() < 3 || input.height() < 3) {
            return false;
        }
        ItemStack p0 = input.getItem(0);
        ItemStack p1 = input.getItem(1);
        ItemStack p2 = input.getItem(2);
        ItemStack w3 = input.getItem(3);
        ItemStack w4 = input.getItem(4);
        ItemStack w5 = input.getItem(5);
        ItemStack p6 = input.getItem(6);
        ItemStack p7 = input.getItem(7);
        ItemStack p8 = input.getItem(8);
        if (p0.isEmpty() || p1.isEmpty() || p2.isEmpty() || w3.isEmpty() || w4.isEmpty() || w5.isEmpty() || p6.isEmpty() || p7.isEmpty() || p8.isEmpty()) {
            return false;
        }
        if (!(p0.is(Items.PAPER) && p1.is(Items.PAPER) && p2.is(Items.PAPER))) {
            return false;
        }
        if (!(p6.is(Items.PAPER) && p7.is(Items.PAPER) && p8.is(Items.PAPER))) {
            return false;
        }
        if (!(w3.is(ModTags.WEEDS) && w4.is(ModTags.WEEDS) && w5.is(ModTags.WEEDS))) {
            return false;
        }
        int nonEmpty = 0;
        for (int i = 0; i < input.size(); ++i) {
            if (input.getItem(i).isEmpty()) continue;
            ++nonEmpty;
        }
        return nonEmpty == 9;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        if (!this.hasPattern(input)) {
            return ItemStack.EMPTY;
        }
        ItemStack w3 = input.getItem(3);
        ItemStack w4 = input.getItem(4);
        ItemStack w5 = input.getItem(5);
        ArrayList<ItemStack> weeds = new ArrayList<ItemStack>(3);
        weeds.add(w3);
        weeds.add(w4);
        weeds.add(w5);
        ItemStack blunt = new ItemStack((ItemLike)this.bluntResult);
        BluntItem.storeWeeds(blunt, weeds);
        return blunt;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w >= 3 && h >= 3;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)this.bluntResult);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.BLUNT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<BluntRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<BluntRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("result").forGetter(r -> BuiltInRegistries.ITEM.getKey((Object)r.bluntResult)), (App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(CustomRecipe::category)).apply((Applicative)instance, (resultRL, cat) -> new BluntRecipe((CraftingBookCategory)cat, (Item)BuiltInRegistries.ITEM.get(resultRL))));
        private static final StreamCodec<RegistryFriendlyByteBuf, BluntRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            buf.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)recipe.bluntResult));
            buf.writeEnum((Enum)recipe.category());
        }, buf -> {
            ResourceLocation res = buf.readResourceLocation();
            CraftingBookCategory cat = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            return new BluntRecipe(cat, (Item)BuiltInRegistries.ITEM.get(res));
        });

        public MapCodec<BluntRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BluntRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

