/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientWithCount(Ingredient ingredient, int count) {
    public static final Codec<IngredientWithCount> CODEC = new Codec<IngredientWithCount>(){

        public <T> DataResult<Pair<IngredientWithCount, T>> decode(DynamicOps<T> ops, T input) {
            DataResult ingr = Ingredient.CODEC_NONEMPTY.parse(ops, input);
            int count = this.readCount(ops, input);
            return ingr.map(i -> Pair.of((Object)new IngredientWithCount((Ingredient)i, Math.max(1, count)), (Object)input));
        }

        private <T> int readCount(DynamicOps<T> ops, T input) {
            DataResult parsed;
            MapLike m;
            Object countElem;
            int c = 1;
            DataResult map = ops.getMap(input);
            if (map.result().isPresent() && (countElem = (m = (MapLike)map.result().get()).get("count")) != null && (parsed = Codec.INT.parse(ops, countElem)).result().isPresent()) {
                c = (Integer)parsed.result().get();
            }
            return c;
        }

        public <T> DataResult<T> encode(IngredientWithCount value, DynamicOps<T> ops, T prefix) {
            DataResult base = Ingredient.CODEC_NONEMPTY.encodeStart(ops, (Object)value.ingredient());
            if (base.result().isPresent()) {
                Object enc = base.result().get();
                DataResult asMap = ops.getMap(enc);
                if (asMap.result().isPresent()) {
                    RecordBuilder builder = ops.mapBuilder();
                    MapLike m = (MapLike)asMap.result().get();
                    m.entries().forEach(p -> builder.add(p.getFirst(), p.getSecond()));
                    if (value.count() > 1) {
                        builder.add(ops.createString("count"), Codec.INT.encodeStart(ops, (Object)value.count()));
                    }
                    return builder.build(prefix);
                }
                RecordBuilder builder = ops.mapBuilder();
                builder.add(ops.createString("ingredient"), enc);
                if (value.count() > 1) {
                    builder.add(ops.createString("count"), Codec.INT.encodeStart(ops, (Object)value.count()));
                }
                return builder.build(prefix);
            }
            return DataResult.error(() -> "Failed to encode ingredient");
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientWithCount> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, IngredientWithCount::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, IngredientWithCount::count, IngredientWithCount::new);

    public Ingredient asDisplayIngredient() {
        ItemStack[] items = this.ingredient.getItems();
        if (items.length == 0) {
            return this.ingredient;
        }
        ItemStack[] counted = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            counted[i] = items[i].copyWithCount(this.count);
        }
        return Ingredient.of((ItemStack[])counted);
    }
}

