/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.stream.Stream;
import net.micaxs.smokeleaf.recipe.IngredientWithCount;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.MutatorRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public record MutatorRecipe(NonNullList<IngredientWithCount> inputItems, FluidStack fluid, ItemStack output) implements Recipe<MutatorRecipeInput>
{
    private static final MapCodec<FluidStack> FLUID_STACK_JSON = new MapCodec<FluidStack>(){

        public <T> DataResult<FluidStack> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object idElem = input.get("FluidName");
            Object amtElem = input.get("Amount");
            if (idElem == null || amtElem == null) {
                return DataResult.error(() -> "Missing fluid keys \"FluidName\" and/or \"Amount\"");
            }
            DataResult id = ResourceLocation.CODEC.parse(ops, idElem);
            DataResult amt = Codec.INT.parse(ops, amtElem);
            return id.apply2((rl, a) -> new FluidStack((Fluid)BuiltInRegistries.FLUID.get(rl), Math.max(0, a)), amt);
        }

        public <T> RecordBuilder<T> encode(FluidStack value, DynamicOps<T> ops, RecordBuilder<T> builder) {
            ResourceLocation rl = BuiltInRegistries.FLUID.getKey((Object)value.getFluid());
            builder.add(ops.createString("FluidName"), ResourceLocation.CODEC.encodeStart(ops, (Object)rl));
            builder.add(ops.createString("Amount"), Codec.INT.encodeStart(ops, (Object)value.getAmount()));
            return builder;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("FluidName"), ops.createString("Amount"));
        }
    };
    private static final MapCodec<ItemStack> OUTPUT_STACK_JSON = new MapCodec<ItemStack>(){

        public <T> DataResult<ItemStack> decode(DynamicOps<T> ops, MapLike<T> input) {
            DataResult c;
            Object itemElem = input.get("item");
            if (itemElem == null) {
                return DataResult.error(() -> "Missing output key \"item\"");
            }
            DataResult id = ResourceLocation.CODEC.parse(ops, itemElem);
            Object countElem = input.get("count");
            int count = countElem != null ? ((c = Codec.INT.parse(ops, countElem)).result().isPresent() ? (Integer)c.result().get() : 1) : 1;
            return id.map(rl -> {
                Item it = (Item)BuiltInRegistries.ITEM.get(rl);
                return new ItemStack((ItemLike)it, Math.max(1, count));
            });
        }

        public <T> RecordBuilder<T> encode(ItemStack value, DynamicOps<T> ops, RecordBuilder<T> builder) {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)value.getItem());
            builder.add(ops.createString("item"), ResourceLocation.CODEC.encodeStart(ops, (Object)rl));
            if (value.getCount() > 1) {
                builder.add(ops.createString("count"), Codec.INT.encodeStart(ops, (Object)value.getCount()));
            }
            return builder;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("item"), ops.createString("count"));
        }
    };

    public FluidStack getFluid() {
        return this.fluid;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        for (IngredientWithCount iwc : this.inputItems) {
            list.add((Object)iwc.asDisplayIngredient());
        }
        return list;
    }

    public boolean matches(MutatorRecipeInput input, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        if (this.inputItems.size() != 2) {
            return false;
        }
        IngredientWithCount a = (IngredientWithCount)this.inputItems.get(0);
        IngredientWithCount b = (IngredientWithCount)this.inputItems.get(1);
        ItemStack seed = input.seedInput();
        ItemStack extract = input.extractInput();
        if (!a.ingredient().test(seed) || seed.getCount() < a.count()) {
            return false;
        }
        return b.ingredient().test(extract) && extract.getCount() >= b.count();
    }

    public ItemStack assemble(MutatorRecipeInput input, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.MUTATOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.MUTATOR_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<MutatorRecipe> {
        public static final MapCodec<MutatorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IngredientWithCount.CODEC.listOf().fieldOf("ingredients").forGetter(r -> r.inputItems), (App)FLUID_STACK_JSON.fieldOf("fluid").forGetter(r -> r.fluid), (App)OUTPUT_STACK_JSON.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)instance, (ingredients, fluid, output) -> {
            NonNullList list = NonNullList.create();
            list.addAll((Collection)ingredients);
            return new MutatorRecipe((NonNullList<IngredientWithCount>)list, (FluidStack)fluid, (ItemStack)output);
        }));
        public static final StreamCodec<RegistryFriendlyByteBuf, MutatorRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MutatorRecipe>(){

            public MutatorRecipe decode(RegistryFriendlyByteBuf buf) {
                int size = buf.readVarInt();
                NonNullList ings = NonNullList.create();
                for (int i = 0; i < size; ++i) {
                    ings.add((Object)((IngredientWithCount)IngredientWithCount.STREAM_CODEC.decode((Object)buf)));
                }
                FluidStack fluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buf);
                ItemStack out = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                return new MutatorRecipe((NonNullList<IngredientWithCount>)ings, fluid, out);
            }

            public void encode(RegistryFriendlyByteBuf buf, MutatorRecipe value) {
                buf.writeVarInt(value.inputItems.size());
                for (IngredientWithCount iwc : value.inputItems) {
                    IngredientWithCount.STREAM_CODEC.encode((Object)buf, (Object)iwc);
                }
                FluidStack.STREAM_CODEC.encode((Object)buf, (Object)value.fluid);
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)value.output);
            }
        };

        public MapCodec<MutatorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MutatorRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

