/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.micaxs.smokeleaf.component.DNAContents;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.DNAStrandItem;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.SequencerRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record SequencerRecipe(Ingredient dnaIngredient, Ingredient baseExtractIngredient, Ingredient[] requiredReagents, ItemStack result) implements Recipe<SequencerRecipeInput>
{
    public static final int REAGENT_SLOTS = 3;

    public boolean matches(SequencerRecipeInput input, Level level) {
        int i;
        if (!(input.dna().getItem() instanceof DNAStrandItem)) {
            return false;
        }
        if (!this.dnaIngredient.test(input.dna())) {
            return false;
        }
        if (!this.baseExtractIngredient.test(input.baseExtract())) {
            return false;
        }
        if (!level.isClientSide()) {
            boolean bl = input.dna().has((DataComponentType)ModDataComponentTypes.DNA_CONTENTS.get());
        }
        if (!level.isClientSide()) {
            boolean hasComp = input.dna().has((DataComponentType)ModDataComponentTypes.DNA_CONTENTS.get());
            DNAContents raw = DNAStrandItem.getContents(input.dna());
            for (i = 0; i < 3; ++i) {
                ItemStack itemStack = raw.get(i);
            }
        }
        DNAContents contents = DNAStrandItem.getContents(input.dna());
        ArrayList<ItemStack> inside = new ArrayList<ItemStack>(3);
        for (i = 0; i < 3; ++i) {
            ItemStack stack = contents.get(i);
            if (stack.isEmpty()) {
                return false;
            }
            inside.add(stack);
        }
        boolean[] used = new boolean[inside.size()];
        for (int r = 0; r < this.requiredReagents.length; ++r) {
            Ingredient required = this.requiredReagents[r];
            boolean found = false;
            for (int i2 = 0; i2 < inside.size(); ++i2) {
                if (used[i2] || !required.test((ItemStack)inside.get(i2))) continue;
                used[i2] = true;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(SequencerRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SEQUENCER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.SEQUENCER_TYPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.dnaIngredient);
        list.add((Object)this.baseExtractIngredient);
        list.addAll(List.of(this.requiredReagents));
        return list;
    }

    public static class Serializer
    implements RecipeSerializer<SequencerRecipe> {
        private static final Codec<ItemStack> RESULT_STACK_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("id").forGetter(s -> (Item)s.getItemHolder().value()), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::getCount)).apply((Applicative)inst, (item, count) -> new ItemStack((ItemLike)item, count.intValue())));
        private static final MapCodec<SequencerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("dna").forGetter(SequencerRecipe::dnaIngredient), (App)Ingredient.CODEC_NONEMPTY.fieldOf("base_extract").forGetter(SequencerRecipe::baseExtractIngredient), (App)Ingredient.CODEC.listOf().fieldOf("required_reagents").flatXmap(list -> list.size() == 3 ? DataResult.success((Object)list) : DataResult.error(() -> "required_reagents must have exactly 3"), DataResult::success).forGetter(r -> List.of(r.requiredReagents)), (App)RESULT_STACK_CODEC.fieldOf("result").forGetter(SequencerRecipe::result)).apply((Applicative)instance, (dna, base, reagentsList, result) -> new SequencerRecipe((Ingredient)dna, (Ingredient)base, (Ingredient[])reagentsList.toArray(Ingredient[]::new), (ItemStack)result)));
        private static final StreamCodec<RegistryFriendlyByteBuf, SequencerRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SequencerRecipe>(){

            public SequencerRecipe decode(RegistryFriendlyByteBuf buf) {
                Ingredient dna = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
                Ingredient base = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
                Ingredient[] req = new Ingredient[3];
                for (int i = 0; i < 3; ++i) {
                    req[i] = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
                }
                ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                return new SequencerRecipe(dna, base, req, result);
            }

            public void encode(RegistryFriendlyByteBuf buf, SequencerRecipe value) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)value.dnaIngredient);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)value.baseExtractIngredient);
                for (Ingredient ing : value.requiredReagents) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ing);
                }
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)value.result);
            }
        };

        public MapCodec<SequencerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SequencerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

