/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.vlib.api;

import g_mungus.vlib.VLib;
import g_mungus.vlib.structure.StructureManager;
import g_mungus.vlib.util.CanFillByConnectivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b(\u0010)J#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\b\u0010\rJ\u0019\u0010\u0010\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014JA\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010 J5\u0010%\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018\u00a2\u0006\u0004\b%\u0010&J5\u0010%\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018\u00a2\u0006\u0004\b%\u0010'\u00a8\u0006*"}, d2={"Lg_mungus/vlib/api/VLibGameUtils;", "", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/core/BlockPos;", "blockPos", "Ljava/util/concurrent/CompletionStage;", "Lorg/valkyrienskies/core/api/ships/Ship;", "assembleByConnectivity", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)Ljava/util/concurrent/CompletionStage;", "", "Lnet/minecraft/world/level/block/Block;", "blackList", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/List;)Ljava/util/concurrent/CompletionStage;", "Lorg/joml/primitives/AABBic;", "aabb", "getMin", "(Lorg/joml/primitives/AABBic;)Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/core/Vec3i;", "getSize", "(Lorg/joml/primitives/AABBic;)Lnet/minecraft/core/Vec3i;", "", "structurePath", "ship", "", "withEntities", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;", "structureTemplateManager", "Lkotlin/Pair;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;", "Lnet/minecraft/resources/ResourceLocation;", "getStructureTemplate", "(Ljava/lang/String;Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/core/api/ships/Ship;ZLnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplateManager;)Lkotlin/Pair;", "", "shipId", "deleteAfter", "", "saveShipToTemplate", "(Ljava/lang/String;Lnet/minecraft/server/level/ServerLevel;JZZ)V", "(Ljava/lang/String;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;ZZ)V", "<init>", "()V", "vlib"})
public final class VLibGameUtils {
    @NotNull
    public static final VLibGameUtils INSTANCE = new VLibGameUtils();

    private VLibGameUtils() {
    }

    @NotNull
    public final CompletionStage<Ship> assembleByConnectivity(@NotNull ServerLevel level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        return this.assembleByConnectivity(level, blockPos, CollectionsKt.emptyList());
    }

    @NotNull
    public final CompletionStage<Ship> assembleByConnectivity(@NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull List<? extends Block> blackList) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter(blackList, (String)"blackList");
        if (VSGameUtilsKt.isBlockInShipyard((Level)((Level)level), (BlockPos)blockPos)) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(new IllegalArgumentException("Ship is already assembled"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Ship> future = new CompletableFuture<Ship>();
        ResourceLocation id = new ResourceLocation("vlib", "ships/" + Random.Default.nextInt());
        StructureTemplate template = level.m_215082_().m_230359_(id);
        Intrinsics.checkNotNull((Object)template, (String)"null cannot be cast to non-null type g_mungus.vlib.util.CanFillByConnectivity");
        ((CanFillByConnectivity)template).vlib$fillByConnectivity((Level)level, blockPos, blackList).whenComplete((arg_0, arg_1) -> VLibGameUtils.assembleByConnectivity$lambda$0((Function2)new Function2<Pair<? extends Set<BlockPos>, ? extends BlockPos>, Throwable, Unit>(future, template, id, level, blockPos){
            final /* synthetic */ CompletableFuture<Ship> $future;
            final /* synthetic */ StructureTemplate $template;
            final /* synthetic */ ResourceLocation $id;
            final /* synthetic */ ServerLevel $level;
            final /* synthetic */ BlockPos $blockPos;
            {
                this.$future = $future;
                this.$template = $template;
                this.$id = $id;
                this.$level = $level;
                this.$blockPos = $blockPos;
                super(2);
            }

            public final void invoke(Pair<? extends Set<BlockPos>, ? extends BlockPos> t, Throwable u) {
                block4: {
                    Pair<? extends Set<BlockPos>, ? extends BlockPos> pair = t;
                    if (pair != null) {
                        Pair<? extends Set<BlockPos>, ? extends BlockPos> pair2 = pair;
                        CompletableFuture<Ship> completableFuture = this.$future;
                        StructureTemplate structureTemplate = this.$template;
                        ResourceLocation resourceLocation = this.$id;
                        ServerLevel serverLevel = this.$level;
                        BlockPos blockPos = this.$blockPos;
                        Pair<? extends Set<BlockPos>, ? extends BlockPos> it = pair2;
                        boolean bl = false;
                        Enumeration<BlockPos> enumeration = StructureManager.INSTANCE.getBlacklist().keys();
                        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
                        ArrayList<BlockPos> arrayList = Collections.list(enumeration);
                        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                        if (((List)arrayList).contains(t.getSecond())) {
                            completableFuture.completeExceptionally(new IllegalStateException("Position is on assembly cooldown"));
                            return;
                        }
                        structureTemplate.m_74612_("vlib$ready%" + resourceLocation);
                        structureTemplate.m_230328_((ServerLevelAccessor)serverLevel, (BlockPos)t.getSecond(), (BlockPos)t.getSecond(), new StructurePlaceSettings(), RandomSource.m_216327_(), 2);
                        Object object = it.getFirst();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            BlockPos pos = (BlockPos)element$iv;
                            boolean bl2 = false;
                            BlockEntity be = serverLevel.m_7702_(pos);
                            if (be != null) {
                                serverLevel.m_46747_(pos);
                            }
                            serverLevel.m_7731_(pos, VLib.INSTANCE.getGHOST_BLOCK().m_49966_(), 0);
                        }
                        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(serverLevel, blockPos, it, completableFuture, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ ServerLevel $level;
                            final /* synthetic */ BlockPos $blockPos;
                            final /* synthetic */ Pair<Set<BlockPos>, BlockPos> $it;
                            final /* synthetic */ CompletableFuture<Ship> $future;
                            {
                                this.$level = $level;
                                this.$blockPos = $blockPos;
                                this.$it = $it;
                                this.$future = $future;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        ship = null;
lbl6:
                                        // 2 sources

                                        while (ship == null) {
                                            this.label = 1;
                                            v0 = DelayKt.delay((long)100L, (Continuation)((Continuation)this));
                                            if (v0 == var10_2) {
                                                return var10_2;
                                            }
                                            ** GOTO lbl16
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl16:
                                        // 2 sources

                                        ship = (Ship)CollectionsKt.firstOrNull((List)CollectionsKt.toList((Iterable)VSGameUtilsKt.getShipsIntersecting((Level)((Level)this.$level), (AABB)new AABB(this.$blockPos))));
                                        ** GOTO lbl6
                                    }
                                }
                                this.L$0 = ship;
                                this.label = 2;
                                v1 = DelayKt.delay((long)200L, (Continuation)((Continuation)this));
                                if (v1 == var10_2) {
                                    return var10_2;
                                }
                                ** GOTO lbl28
                                {
                                    case 2: {
                                        ship = (Ship)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl28:
                                        // 2 sources

                                        v2 = this.$it.getFirst();
                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"<get-first>(...)");
                                        var3_4 = (Iterable)v2;
                                        var4_5 = this.$level;
                                        $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            pos = (BlockPos)element$iv;
                                            $i$a$-forEach-VLibGameUtils$assembleByConnectivity$1$1$2$1 = false;
                                            var4_5.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                                        }
                                        v3 = ship;
                                        Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.ServerShip");
                                        ((ServerShip)v3).setStatic(false);
                                        this.$future.complete(ship);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                    Throwable throwable = u;
                    if (throwable == null) break block4;
                    throwable.printStackTrace();
                }
            }
        }, arg_0, arg_1));
        return future;
    }

    public final void saveShipToTemplate(@NotNull String structurePath, @NotNull ServerLevel level, @NotNull BlockPos blockPos, boolean withEntities, boolean deleteAfter) {
        Long shipID;
        Intrinsics.checkNotNullParameter((Object)structurePath, (String)"structurePath");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        ServerShip serverShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)blockPos);
        Long l = shipID = serverShip != null ? Long.valueOf(serverShip.getId()) : null;
        if (shipID != null) {
            this.saveShipToTemplate(structurePath, level, shipID, withEntities, deleteAfter);
        } else {
            VLib.INSTANCE.getLOGGER().error("Could not find ship for blockPos: " + blockPos + " in world: " + VSGameUtilsKt.getDimensionId((Level)((Level)level)));
        }
    }

    public final void saveShipToTemplate(@NotNull String structurePath, @NotNull ServerLevel level, long shipId, boolean withEntities, boolean deleteAfter) {
        Intrinsics.checkNotNullParameter((Object)structurePath, (String)"structurePath");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Ship ship = VSGameUtilsKt.getAllShips((Level)((Level)level)).getById(shipId);
        if (ship == null) {
            VLibGameUtils it = this;
            boolean bl = false;
            VLib.INSTANCE.getLOGGER().error("Could not find ship id: " + shipId + " in world: " + VSGameUtilsKt.getDimensionId((Level)((Level)level)));
            return;
        }
        Ship ship2 = ship;
        StructureTemplateManager structureTemplateManager = level.m_215082_();
        Intrinsics.checkNotNull((Object)structureTemplateManager);
        structureTemplateManager.m_230416_((ResourceLocation)this.getStructureTemplate(structurePath, level, ship2, withEntities, structureTemplateManager).getSecond());
        if (deleteAfter) {
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).deleteShip((ServerShip)ship2);
        }
    }

    @NotNull
    public final Pair<StructureTemplate, ResourceLocation> getStructureTemplate(@NotNull String structurePath, @NotNull ServerLevel level, @NotNull Ship ship, boolean withEntities, @NotNull StructureTemplateManager structureTemplateManager) {
        ResourceLocation resourceLocation;
        String shipName;
        Intrinsics.checkNotNullParameter((Object)structurePath, (String)"structurePath");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)structureTemplateManager, (String)"structureTemplateManager");
        Object object = ship.getSlug();
        if (object == null) {
            object = shipName = "ship_" + Random.Default.nextInt();
        }
        if (StringsKt.contains$default((CharSequence)structurePath, (char)':', (boolean)false, (int)2, null)) {
            resourceLocation = new ResourceLocation(structurePath + shipName);
        } else {
            if (StringsKt.contains$default((CharSequence)structurePath, (char)'/', (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Invalid structure path: the required format is either:\nnamespace\n- or -\nnamespace:folder/");
            }
            resourceLocation = new ResourceLocation(structurePath, shipName);
        }
        ResourceLocation resourceLocation2 = resourceLocation;
        StructureTemplate structureTemplate = structureTemplateManager.m_230359_(resourceLocation2);
        structureTemplate.m_163802_((Level)level, this.getMin(ship.getShipAABB()), this.getSize(ship.getShipAABB()), withEntities, Blocks.f_50016_);
        return new Pair((Object)structureTemplate, (Object)resourceLocation2);
    }

    private final BlockPos getMin(AABBic aabb) {
        if (aabb != null) {
            return new BlockPos(aabb.minX() - 1, aabb.minY() - 1, aabb.minZ() - 1);
        }
        throw new Exception("Why doesn't the ship have a shipyard AABB?");
    }

    private final Vec3i getSize(AABBic aabb) {
        if (aabb != null) {
            return new Vec3i(aabb.maxX() - aabb.minX() + 2, aabb.maxY() - aabb.minY() + 2, aabb.maxZ() - aabb.minZ() + 2);
        }
        throw new Exception("Why doesn't the ship have a shipyard AABB?");
    }

    private static final void assembleByConnectivity$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

