/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.vlib.dimension;

import g_mungus.vlib.data.DimensionSettings;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lg_mungus/vlib/dimension/DimensionSettingsManager;", "", "Lnet/minecraft/resources/ResourceLocation;", "dimensionID", "Lg_mungus/vlib/data/DimensionSettings;", "settings", "", "addSettings", "(Lnet/minecraft/resources/ResourceLocation;Lg_mungus/vlib/data/DimensionSettings;)V", "", "", "getModifiedDimensions", "()Ljava/util/Map;", "dimensionKey", "getSettingsForLevel", "(Ljava/lang/String;)Lg_mungus/vlib/data/DimensionSettings;", "DEFAULT", "Lg_mungus/vlib/data/DimensionSettings;", "", "modifiedDimensions", "Ljava/util/Map;", "<init>", "()V", "vlib"})
public final class DimensionSettingsManager {
    @NotNull
    public static final DimensionSettingsManager INSTANCE = new DimensionSettingsManager();
    @NotNull
    private static Map<String, DimensionSettings> modifiedDimensions = new LinkedHashMap();
    @NotNull
    private static final DimensionSettings DEFAULT = new DimensionSettings(1.0, 1.0);

    private DimensionSettingsManager() {
    }

    public final void addSettings(@NotNull ResourceLocation dimensionID, @NotNull DimensionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)dimensionID, (String)"dimensionID");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Map<String, DimensionSettings> map = modifiedDimensions;
        String string = dimensionID.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        map.put(string, settings);
    }

    @NotNull
    public final Map<String, DimensionSettings> getModifiedDimensions() {
        return MapsKt.toMap(modifiedDimensions);
    }

    @NotNull
    public final DimensionSettings getSettingsForLevel(@NotNull String dimensionKey) {
        Intrinsics.checkNotNullParameter((Object)dimensionKey, (String)"dimensionKey");
        String key = StringsKt.drop((String)dimensionKey, (int)20);
        DimensionSettings dimensionSettings = modifiedDimensions.get(key);
        if (dimensionSettings == null) {
            dimensionSettings = DEFAULT;
        }
        return dimensionSettings;
    }
}

